<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControlFault StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccessControlFault
 * @subpackage Structs
 */
class AccessControlFault extends AbstractStructBase
{
    /**
     * The ErroCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErroCode;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * Constructor method for AccessControlFault
     * @uses AccessControlFault::setErroCode()
     * @uses AccessControlFault::setMessage()
     * @param int $erroCode
     * @param string $message
     */
    public function __construct($erroCode = null, $message = null)
    {
        $this
            ->setErroCode($erroCode)
            ->setMessage($message);
    }
    /**
     * Get ErroCode value
     * @return int|null
     */
    public function getErroCode()
    {
        return $this->ErroCode;
    }
    /**
     * Set ErroCode value
     * @param int $erroCode
     * @return \StructType\AccessControlFault
     */
    public function setErroCode($erroCode = null)
    {
        // validation for constraint: int
        if (!is_null($erroCode) && !(is_int($erroCode) || ctype_digit($erroCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($erroCode, true), gettype($erroCode)), __LINE__);
        }
        $this->ErroCode = $erroCode;
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \StructType\AccessControlFault
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
}
