<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Inquiry ServiceType
 * @subpackage Services
 */
class Inquiry extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Inquiry_LegalPerson
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Inquiry_LegalPerson $parameters
     * @return \StructType\Inquiry_LegalPersonResponse|bool
     */
    public function Inquiry_LegalPerson(\StructType\Inquiry_LegalPerson $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Inquiry_LegalPerson($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Inquiry_RealPerson
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Inquiry_RealPerson $parameters
     * @return \StructType\Inquiry_RealPersonResponse|bool
     */
    public function Inquiry_RealPerson(\StructType\Inquiry_RealPerson $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Inquiry_RealPerson($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Inquiry_PostalCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Inquiry_PostalCode $parameters
     * @return \StructType\Inquiry_PostalCodeResponse|bool
     */
    public function Inquiry_PostalCode(\StructType\Inquiry_PostalCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Inquiry_PostalCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Inquiry_Insurance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Inquiry_Insurance $parameters
     * @return \StructType\Inquiry_InsuranceResponse|bool
     */
    public function Inquiry_Insurance(\StructType\Inquiry_Insurance $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Inquiry_Insurance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Inquiry_RadTaeid_Barnameh
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Inquiry_RadTaeid_Barnameh $parameters
     * @return \StructType\Inquiry_RadTaeid_BarnamehResponse|bool
     */
    public function Inquiry_RadTaeid_Barnameh(\StructType\Inquiry_RadTaeid_Barnameh $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Inquiry_RadTaeid_Barnameh($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Inquiry_TradeDocInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Inquiry_TradeDocInformation $parameters
     * @return \StructType\Inquiry_TradeDocInformationResponse|bool
     */
    public function Inquiry_TradeDocInformation(\StructType\Inquiry_TradeDocInformation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Inquiry_TradeDocInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Inquiry_CheckWaybillAssign
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Inquiry_CheckWaybillAssign $parameters
     * @return \StructType\Inquiry_CheckWaybillAssignResponse|bool
     */
    public function Inquiry_CheckWaybillAssign(\StructType\Inquiry_CheckWaybillAssign $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Inquiry_CheckWaybillAssign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Inquiry_CheckWaybillAssignResponse|\StructType\Inquiry_InsuranceResponse|\StructType\Inquiry_LegalPersonResponse|\StructType\Inquiry_PostalCodeResponse|\StructType\Inquiry_RadTaeid_BarnamehResponse|\StructType\Inquiry_RealPersonResponse|\StructType\Inquiry_TradeDocInformationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
