<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetDriverBySmartCardNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDriverBySmartCardNo $parameters
     * @return \StructType\GetDriverBySmartCardNoResponse|bool
     */
    public function GetDriverBySmartCardNo(\StructType\GetDriverBySmartCardNo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDriverBySmartCardNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDriverByNational_ID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDriverByNational_ID $parameters
     * @return \StructType\GetDriverByNational_IDResponse|bool
     */
    public function GetDriverByNational_ID(\StructType\GetDriverByNational_ID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDriverByNational_ID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFreighterBySmartCardNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFreighterBySmartCardNo $parameters
     * @return \StructType\GetFreighterBySmartCardNoResponse|bool
     */
    public function GetFreighterBySmartCardNo(\StructType\GetFreighterBySmartCardNo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFreighterBySmartCardNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCompanyStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompanyStatus $parameters
     * @return \StructType\GetCompanyStatusResponse|bool
     */
    public function GetCompanyStatus(\StructType\GetCompanyStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCompanyStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFreighterBySmartCardNoFull
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFreighterBySmartCardNoFull $parameters
     * @return \StructType\GetFreighterBySmartCardNoFullResponse|bool
     */
    public function GetFreighterBySmartCardNoFull(\StructType\GetFreighterBySmartCardNoFull $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFreighterBySmartCardNoFull($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetBillOfLadingByFreighterCardNumberInToday
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBillOfLadingByFreighterCardNumberInToday $parameters
     * @return \StructType\GetBillOfLadingByFreighterCardNumberInTodayResponse|bool
     */
    public function GetBillOfLadingByFreighterCardNumberInToday(\StructType\GetBillOfLadingByFreighterCardNumberInToday $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBillOfLadingByFreighterCardNumberInToday($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetBillOfLadingByDriverCardNumberInToday
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBillOfLadingByDriverCardNumberInToday $parameters
     * @return \StructType\GetBillOfLadingByDriverCardNumberInTodayResponse|bool
     */
    public function GetBillOfLadingByDriverCardNumberInToday(\StructType\GetBillOfLadingByDriverCardNumberInToday $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBillOfLadingByDriverCardNumberInToday($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetBillOfLadingByDriverNationalIdInToday
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBillOfLadingByDriverNationalIdInToday $parameters
     * @return \StructType\GetBillOfLadingByDriverNationalIdInTodayResponse|bool
     */
    public function GetBillOfLadingByDriverNationalIdInToday(\StructType\GetBillOfLadingByDriverNationalIdInToday $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBillOfLadingByDriverNationalIdInToday($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBillOfLadingByDriverNationalID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBillOfLadingByDriverNationalID $parameters
     * @return \StructType\GetBillOfLadingByDriverNationalIDResponse|bool
     */
    public function GetBillOfLadingByDriverNationalID(\StructType\GetBillOfLadingByDriverNationalID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBillOfLadingByDriverNationalID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBillOfLadingByPlaque
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBillOfLadingByPlaque $parameters
     * @return \StructType\GetBillOfLadingByPlaqueResponse|bool
     */
    public function GetBillOfLadingByPlaque(\StructType\GetBillOfLadingByPlaque $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBillOfLadingByPlaque($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRmtoCurrentDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRmtoCurrentDate $parameters
     * @return \StructType\GetRmtoCurrentDateResponse|bool
     */
    public function GetRmtoCurrentDate(\StructType\GetRmtoCurrentDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRmtoCurrentDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetBillOfLadingByDriverCardNumberInTodayResponse|\StructType\GetBillOfLadingByDriverNationalIdInTodayResponse|\StructType\GetBillOfLadingByDriverNationalIDResponse|\StructType\GetBillOfLadingByFreighterCardNumberInTodayResponse|\StructType\GetBillOfLadingByPlaqueResponse|\StructType\GetCompanyStatusResponse|\StructType\GetDriverByNational_IDResponse|\StructType\GetDriverBySmartCardNoResponse|\StructType\GetFreighterBySmartCardNoFullResponse|\StructType\GetFreighterBySmartCardNoResponse|\StructType\GetRmtoCurrentDateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
