<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBillOfLadingInfo ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfBillOfLadingInfo
 * @subpackage Arrays
 */
class ArrayOfBillOfLadingInfo extends AbstractStructArrayBase
{
    /**
     * The BillOfLadingInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BillOfLadingInfo[]
     */
    public $BillOfLadingInfo;
    /**
     * Constructor method for ArrayOfBillOfLadingInfo
     * @uses ArrayOfBillOfLadingInfo::setBillOfLadingInfo()
     * @param \StructType\BillOfLadingInfo[] $billOfLadingInfo
     */
    public function __construct(array $billOfLadingInfo = array())
    {
        $this
            ->setBillOfLadingInfo($billOfLadingInfo);
    }
    /**
     * Get BillOfLadingInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BillOfLadingInfo[]|null
     */
    public function getBillOfLadingInfo()
    {
        return isset($this->BillOfLadingInfo) ? $this->BillOfLadingInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBillOfLadingInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillOfLadingInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillOfLadingInfoForArrayConstraintsFromSetBillOfLadingInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBillOfLadingInfoBillOfLadingInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfBillOfLadingInfoBillOfLadingInfoItem instanceof \StructType\BillOfLadingInfo) {
                $invalidValues[] = is_object($arrayOfBillOfLadingInfoBillOfLadingInfoItem) ? get_class($arrayOfBillOfLadingInfoBillOfLadingInfoItem) : sprintf('%s(%s)', gettype($arrayOfBillOfLadingInfoBillOfLadingInfoItem), var_export($arrayOfBillOfLadingInfoBillOfLadingInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BillOfLadingInfo property can only contain items of type \StructType\BillOfLadingInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BillOfLadingInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BillOfLadingInfo[] $billOfLadingInfo
     * @return \ArrayType\ArrayOfBillOfLadingInfo
     */
    public function setBillOfLadingInfo(array $billOfLadingInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($billOfLadingInfoArrayErrorMessage = self::validateBillOfLadingInfoForArrayConstraintsFromSetBillOfLadingInfo($billOfLadingInfo))) {
            throw new \InvalidArgumentException($billOfLadingInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($billOfLadingInfo) || (is_array($billOfLadingInfo) && empty($billOfLadingInfo))) {
            unset($this->BillOfLadingInfo);
        } else {
            $this->BillOfLadingInfo = $billOfLadingInfo;
        }
        return $this;
    }
    /**
     * Add item to BillOfLadingInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\BillOfLadingInfo $item
     * @return \ArrayType\ArrayOfBillOfLadingInfo
     */
    public function addToBillOfLadingInfo(\StructType\BillOfLadingInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BillOfLadingInfo) {
            throw new \InvalidArgumentException(sprintf('The BillOfLadingInfo property can only contain items of type \StructType\BillOfLadingInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BillOfLadingInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BillOfLadingInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BillOfLadingInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BillOfLadingInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BillOfLadingInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BillOfLadingInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BillOfLadingInfo
     */
    public function getAttributeName()
    {
        return 'BillOfLadingInfo';
    }
}
