<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Insert ServiceType
 */
$insert = new \ServiceType\Insert($options);
/**
 * Sample call for InsertBillOfLading operation/method
 */
if ($insert->InsertBillOfLading(new \StructType\InsertBillOfLading()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Samples for Register ServiceType
 */
$register = new \ServiceType\Register($options);
/**
 * Sample call for RegisterBillOfLadingFormAsDamaged operation/method
 */
if ($register->RegisterBillOfLadingFormAsDamaged(new \StructType\RegisterBillOfLadingFormAsDamaged()) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Sample call for RegisterReceipt operation/method
 */
if ($register->RegisterReceipt(new \StructType\RegisterReceipt()) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Samples for Load ServiceType
 */
$load = new \ServiceType\Load($options);
/**
 * Sample call for LoadBillOfLadingByNumber operation/method
 */
if ($load->LoadBillOfLadingByNumber(new \StructType\LoadBillOfLadingByNumber()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Sample call for LoadAllBillOfLadingByNumber operation/method
 */
if ($load->LoadAllBillOfLadingByNumber(new \StructType\LoadAllBillOfLadingByNumber()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetDriverBySmartCardNo operation/method
 */
if ($get->GetDriverBySmartCardNo(new \StructType\GetDriverBySmartCardNo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDriverByNational_ID operation/method
 */
if ($get->GetDriverByNational_ID(new \StructType\GetDriverByNational_ID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFreighterBySmartCardNo operation/method
 */
if ($get->GetFreighterBySmartCardNo(new \StructType\GetFreighterBySmartCardNo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompanyStatus operation/method
 */
if ($get->GetCompanyStatus(new \StructType\GetCompanyStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFreighterBySmartCardNoFull operation/method
 */
if ($get->GetFreighterBySmartCardNoFull(new \StructType\GetFreighterBySmartCardNoFull()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBillOfLadingByFreighterCardNumberInToday operation/method
 */
if ($get->GetBillOfLadingByFreighterCardNumberInToday(new \StructType\GetBillOfLadingByFreighterCardNumberInToday()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBillOfLadingByDriverCardNumberInToday operation/method
 */
if ($get->GetBillOfLadingByDriverCardNumberInToday(new \StructType\GetBillOfLadingByDriverCardNumberInToday()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBillOfLadingByDriverNationalIdInToday operation/method
 */
if ($get->GetBillOfLadingByDriverNationalIdInToday(new \StructType\GetBillOfLadingByDriverNationalIdInToday()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBillOfLadingByDriverNationalID operation/method
 */
if ($get->GetBillOfLadingByDriverNationalID(new \StructType\GetBillOfLadingByDriverNationalID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBillOfLadingByPlaque operation/method
 */
if ($get->GetBillOfLadingByPlaque(new \StructType\GetBillOfLadingByPlaque()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRmtoCurrentDate operation/method
 */
if ($get->GetRmtoCurrentDate(new \StructType\GetRmtoCurrentDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeleteReceiptByID operation/method
 */
if ($delete->DeleteReceiptByID(new \StructType\DeleteReceiptByID()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for CheckExistBillOfLadingBySerialAndNumber operation/method
 */
if ($check->CheckExistBillOfLadingBySerialAndNumber(new \StructType\CheckExistBillOfLadingBySerialAndNumber()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Inquiry ServiceType
 */
$inquiry = new \ServiceType\Inquiry($options);
/**
 * Sample call for Inquiry_LegalPerson operation/method
 */
if ($inquiry->Inquiry_LegalPerson(new \StructType\Inquiry_LegalPerson()) !== false) {
    print_r($inquiry->getResult());
} else {
    print_r($inquiry->getLastError());
}
/**
 * Sample call for Inquiry_RealPerson operation/method
 */
if ($inquiry->Inquiry_RealPerson(new \StructType\Inquiry_RealPerson()) !== false) {
    print_r($inquiry->getResult());
} else {
    print_r($inquiry->getLastError());
}
/**
 * Sample call for Inquiry_PostalCode operation/method
 */
if ($inquiry->Inquiry_PostalCode(new \StructType\Inquiry_PostalCode()) !== false) {
    print_r($inquiry->getResult());
} else {
    print_r($inquiry->getLastError());
}
/**
 * Sample call for Inquiry_Insurance operation/method
 */
if ($inquiry->Inquiry_Insurance(new \StructType\Inquiry_Insurance()) !== false) {
    print_r($inquiry->getResult());
} else {
    print_r($inquiry->getLastError());
}
/**
 * Sample call for Inquiry_RadTaeid_Barnameh operation/method
 */
if ($inquiry->Inquiry_RadTaeid_Barnameh(new \StructType\Inquiry_RadTaeid_Barnameh()) !== false) {
    print_r($inquiry->getResult());
} else {
    print_r($inquiry->getLastError());
}
/**
 * Sample call for Inquiry_TradeDocInformation operation/method
 */
if ($inquiry->Inquiry_TradeDocInformation(new \StructType\Inquiry_TradeDocInformation()) !== false) {
    print_r($inquiry->getResult());
} else {
    print_r($inquiry->getLastError());
}
/**
 * Sample call for Inquiry_CheckWaybillAssign operation/method
 */
if ($inquiry->Inquiry_CheckWaybillAssign(new \StructType\Inquiry_CheckWaybillAssign()) !== false) {
    print_r($inquiry->getResult());
} else {
    print_r($inquiry->getLastError());
}
