<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TradeDocInformationContainerCnt StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TradeDocInformationContainerCnt
 * @subpackage Structs
 */
class TradeDocInformationContainerCnt extends AbstractStructBase
{
    /**
     * The AdditionalInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdditionalInformation;
    /**
     * The EmptyWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmptyWeight;
    /**
     * The GoodsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTradeDocInformationGoodsCnt
     */
    public $GoodsList;
    /**
     * The GrossWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GrossWeight;
    /**
     * The Humidity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Humidity;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The LoadVolume
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoadVolume;
    /**
     * The MaxTemp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MaxTemp;
    /**
     * The MinTemp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MinTemp;
    /**
     * The PackagCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PackagCount;
    /**
     * The Seals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTradeDocInformationSealsCnt
     */
    public $Seals;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The UnitTemp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnitTemp;
    /**
     * Constructor method for TradeDocInformationContainerCnt
     * @uses TradeDocInformationContainerCnt::setAdditionalInformation()
     * @uses TradeDocInformationContainerCnt::setEmptyWeight()
     * @uses TradeDocInformationContainerCnt::setGoodsList()
     * @uses TradeDocInformationContainerCnt::setGrossWeight()
     * @uses TradeDocInformationContainerCnt::setHumidity()
     * @uses TradeDocInformationContainerCnt::setID()
     * @uses TradeDocInformationContainerCnt::setLoadVolume()
     * @uses TradeDocInformationContainerCnt::setMaxTemp()
     * @uses TradeDocInformationContainerCnt::setMinTemp()
     * @uses TradeDocInformationContainerCnt::setPackagCount()
     * @uses TradeDocInformationContainerCnt::setSeals()
     * @uses TradeDocInformationContainerCnt::setType()
     * @uses TradeDocInformationContainerCnt::setUnitTemp()
     * @param string $additionalInformation
     * @param string $emptyWeight
     * @param \ArrayType\ArrayOfTradeDocInformationGoodsCnt $goodsList
     * @param string $grossWeight
     * @param string $humidity
     * @param string $iD
     * @param string $loadVolume
     * @param string $maxTemp
     * @param string $minTemp
     * @param int $packagCount
     * @param \ArrayType\ArrayOfTradeDocInformationSealsCnt $seals
     * @param string $type
     * @param string $unitTemp
     */
    public function __construct($additionalInformation = null, $emptyWeight = null, \ArrayType\ArrayOfTradeDocInformationGoodsCnt $goodsList = null, $grossWeight = null, $humidity = null, $iD = null, $loadVolume = null, $maxTemp = null, $minTemp = null, $packagCount = null, \ArrayType\ArrayOfTradeDocInformationSealsCnt $seals = null, $type = null, $unitTemp = null)
    {
        $this
            ->setAdditionalInformation($additionalInformation)
            ->setEmptyWeight($emptyWeight)
            ->setGoodsList($goodsList)
            ->setGrossWeight($grossWeight)
            ->setHumidity($humidity)
            ->setID($iD)
            ->setLoadVolume($loadVolume)
            ->setMaxTemp($maxTemp)
            ->setMinTemp($minTemp)
            ->setPackagCount($packagCount)
            ->setSeals($seals)
            ->setType($type)
            ->setUnitTemp($unitTemp);
    }
    /**
     * Get AdditionalInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdditionalInformation()
    {
        return isset($this->AdditionalInformation) ? $this->AdditionalInformation : null;
    }
    /**
     * Set AdditionalInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $additionalInformation
     * @return \StructType\TradeDocInformationContainerCnt
     */
    public function setAdditionalInformation($additionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInformation) && !is_string($additionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInformation, true), gettype($additionalInformation)), __LINE__);
        }
        if (is_null($additionalInformation) || (is_array($additionalInformation) && empty($additionalInformation))) {
            unset($this->AdditionalInformation);
        } else {
            $this->AdditionalInformation = $additionalInformation;
        }
        return $this;
    }
    /**
     * Get EmptyWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmptyWeight()
    {
        return isset($this->EmptyWeight) ? $this->EmptyWeight : null;
    }
    /**
     * Set EmptyWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emptyWeight
     * @return \StructType\TradeDocInformationContainerCnt
     */
    public function setEmptyWeight($emptyWeight = null)
    {
        // validation for constraint: string
        if (!is_null($emptyWeight) && !is_string($emptyWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emptyWeight, true), gettype($emptyWeight)), __LINE__);
        }
        if (is_null($emptyWeight) || (is_array($emptyWeight) && empty($emptyWeight))) {
            unset($this->EmptyWeight);
        } else {
            $this->EmptyWeight = $emptyWeight;
        }
        return $this;
    }
    /**
     * Get GoodsList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTradeDocInformationGoodsCnt|null
     */
    public function getGoodsList()
    {
        return isset($this->GoodsList) ? $this->GoodsList : null;
    }
    /**
     * Set GoodsList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTradeDocInformationGoodsCnt $goodsList
     * @return \StructType\TradeDocInformationContainerCnt
     */
    public function setGoodsList(\ArrayType\ArrayOfTradeDocInformationGoodsCnt $goodsList = null)
    {
        if (is_null($goodsList) || (is_array($goodsList) && empty($goodsList))) {
            unset($this->GoodsList);
        } else {
            $this->GoodsList = $goodsList;
        }
        return $this;
    }
    /**
     * Get GrossWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGrossWeight()
    {
        return isset($this->GrossWeight) ? $this->GrossWeight : null;
    }
    /**
     * Set GrossWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $grossWeight
     * @return \StructType\TradeDocInformationContainerCnt
     */
    public function setGrossWeight($grossWeight = null)
    {
        // validation for constraint: string
        if (!is_null($grossWeight) && !is_string($grossWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grossWeight, true), gettype($grossWeight)), __LINE__);
        }
        if (is_null($grossWeight) || (is_array($grossWeight) && empty($grossWeight))) {
            unset($this->GrossWeight);
        } else {
            $this->GrossWeight = $grossWeight;
        }
        return $this;
    }
    /**
     * Get Humidity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHumidity()
    {
        return isset($this->Humidity) ? $this->Humidity : null;
    }
    /**
     * Set Humidity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $humidity
     * @return \StructType\TradeDocInformationContainerCnt
     */
    public function setHumidity($humidity = null)
    {
        // validation for constraint: string
        if (!is_null($humidity) && !is_string($humidity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($humidity, true), gettype($humidity)), __LINE__);
        }
        if (is_null($humidity) || (is_array($humidity) && empty($humidity))) {
            unset($this->Humidity);
        } else {
            $this->Humidity = $humidity;
        }
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iD
     * @return \StructType\TradeDocInformationContainerCnt
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get LoadVolume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoadVolume()
    {
        return isset($this->LoadVolume) ? $this->LoadVolume : null;
    }
    /**
     * Set LoadVolume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loadVolume
     * @return \StructType\TradeDocInformationContainerCnt
     */
    public function setLoadVolume($loadVolume = null)
    {
        // validation for constraint: string
        if (!is_null($loadVolume) && !is_string($loadVolume)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loadVolume, true), gettype($loadVolume)), __LINE__);
        }
        if (is_null($loadVolume) || (is_array($loadVolume) && empty($loadVolume))) {
            unset($this->LoadVolume);
        } else {
            $this->LoadVolume = $loadVolume;
        }
        return $this;
    }
    /**
     * Get MaxTemp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaxTemp()
    {
        return isset($this->MaxTemp) ? $this->MaxTemp : null;
    }
    /**
     * Set MaxTemp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $maxTemp
     * @return \StructType\TradeDocInformationContainerCnt
     */
    public function setMaxTemp($maxTemp = null)
    {
        // validation for constraint: string
        if (!is_null($maxTemp) && !is_string($maxTemp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxTemp, true), gettype($maxTemp)), __LINE__);
        }
        if (is_null($maxTemp) || (is_array($maxTemp) && empty($maxTemp))) {
            unset($this->MaxTemp);
        } else {
            $this->MaxTemp = $maxTemp;
        }
        return $this;
    }
    /**
     * Get MinTemp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMinTemp()
    {
        return isset($this->MinTemp) ? $this->MinTemp : null;
    }
    /**
     * Set MinTemp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $minTemp
     * @return \StructType\TradeDocInformationContainerCnt
     */
    public function setMinTemp($minTemp = null)
    {
        // validation for constraint: string
        if (!is_null($minTemp) && !is_string($minTemp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minTemp, true), gettype($minTemp)), __LINE__);
        }
        if (is_null($minTemp) || (is_array($minTemp) && empty($minTemp))) {
            unset($this->MinTemp);
        } else {
            $this->MinTemp = $minTemp;
        }
        return $this;
    }
    /**
     * Get PackagCount value
     * @return int|null
     */
    public function getPackagCount()
    {
        return $this->PackagCount;
    }
    /**
     * Set PackagCount value
     * @param int $packagCount
     * @return \StructType\TradeDocInformationContainerCnt
     */
    public function setPackagCount($packagCount = null)
    {
        // validation for constraint: int
        if (!is_null($packagCount) && !(is_int($packagCount) || ctype_digit($packagCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packagCount, true), gettype($packagCount)), __LINE__);
        }
        $this->PackagCount = $packagCount;
        return $this;
    }
    /**
     * Get Seals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTradeDocInformationSealsCnt|null
     */
    public function getSeals()
    {
        return isset($this->Seals) ? $this->Seals : null;
    }
    /**
     * Set Seals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTradeDocInformationSealsCnt $seals
     * @return \StructType\TradeDocInformationContainerCnt
     */
    public function setSeals(\ArrayType\ArrayOfTradeDocInformationSealsCnt $seals = null)
    {
        if (is_null($seals) || (is_array($seals) && empty($seals))) {
            unset($this->Seals);
        } else {
            $this->Seals = $seals;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \StructType\TradeDocInformationContainerCnt
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UnitTemp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnitTemp()
    {
        return isset($this->UnitTemp) ? $this->UnitTemp : null;
    }
    /**
     * Set UnitTemp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unitTemp
     * @return \StructType\TradeDocInformationContainerCnt
     */
    public function setUnitTemp($unitTemp = null)
    {
        // validation for constraint: string
        if (!is_null($unitTemp) && !is_string($unitTemp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitTemp, true), gettype($unitTemp)), __LINE__);
        }
        if (is_null($unitTemp) || (is_array($unitTemp) && empty($unitTemp))) {
            unset($this->UnitTemp);
        } else {
            $this->UnitTemp = $unitTemp;
        }
        return $this;
    }
}
