<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResponseItem
 * @subpackage Structs
 */
class ResponseItem extends AbstractStructBase
{
    /**
     * The CorrectPersonInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Person
     */
    public $CorrectPersonInfo;
    /**
     * The InitialPersonInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Person
     */
    public $InitialPersonInfo;
    /**
     * The PostalCodeInquiryResponse
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PostalCodeInquiryResponse;
    /**
     * The RelatedAddressToPostalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedAddressToPostalCode;
    /**
     * The ResponseMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseMessage;
    /**
     * The ResponseType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ResponseType;
    /**
     * Constructor method for ResponseItem
     * @uses ResponseItem::setCorrectPersonInfo()
     * @uses ResponseItem::setInitialPersonInfo()
     * @uses ResponseItem::setPostalCodeInquiryResponse()
     * @uses ResponseItem::setRelatedAddressToPostalCode()
     * @uses ResponseItem::setResponseMessage()
     * @uses ResponseItem::setResponseType()
     * @param \StructType\Person $correctPersonInfo
     * @param \StructType\Person $initialPersonInfo
     * @param string $postalCodeInquiryResponse
     * @param string $relatedAddressToPostalCode
     * @param string $responseMessage
     * @param string $responseType
     */
    public function __construct(\StructType\Person $correctPersonInfo = null, \StructType\Person $initialPersonInfo = null, $postalCodeInquiryResponse = null, $relatedAddressToPostalCode = null, $responseMessage = null, $responseType = null)
    {
        $this
            ->setCorrectPersonInfo($correctPersonInfo)
            ->setInitialPersonInfo($initialPersonInfo)
            ->setPostalCodeInquiryResponse($postalCodeInquiryResponse)
            ->setRelatedAddressToPostalCode($relatedAddressToPostalCode)
            ->setResponseMessage($responseMessage)
            ->setResponseType($responseType);
    }
    /**
     * Get CorrectPersonInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Person|null
     */
    public function getCorrectPersonInfo()
    {
        return isset($this->CorrectPersonInfo) ? $this->CorrectPersonInfo : null;
    }
    /**
     * Set CorrectPersonInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Person $correctPersonInfo
     * @return \StructType\ResponseItem
     */
    public function setCorrectPersonInfo(\StructType\Person $correctPersonInfo = null)
    {
        if (is_null($correctPersonInfo) || (is_array($correctPersonInfo) && empty($correctPersonInfo))) {
            unset($this->CorrectPersonInfo);
        } else {
            $this->CorrectPersonInfo = $correctPersonInfo;
        }
        return $this;
    }
    /**
     * Get InitialPersonInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Person|null
     */
    public function getInitialPersonInfo()
    {
        return isset($this->InitialPersonInfo) ? $this->InitialPersonInfo : null;
    }
    /**
     * Set InitialPersonInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Person $initialPersonInfo
     * @return \StructType\ResponseItem
     */
    public function setInitialPersonInfo(\StructType\Person $initialPersonInfo = null)
    {
        if (is_null($initialPersonInfo) || (is_array($initialPersonInfo) && empty($initialPersonInfo))) {
            unset($this->InitialPersonInfo);
        } else {
            $this->InitialPersonInfo = $initialPersonInfo;
        }
        return $this;
    }
    /**
     * Get PostalCodeInquiryResponse value
     * @return string|null
     */
    public function getPostalCodeInquiryResponse()
    {
        return $this->PostalCodeInquiryResponse;
    }
    /**
     * Set PostalCodeInquiryResponse value
     * @uses \EnumType\PostalCodeInquiryResponseType::valueIsValid()
     * @uses \EnumType\PostalCodeInquiryResponseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $postalCodeInquiryResponse
     * @return \StructType\ResponseItem
     */
    public function setPostalCodeInquiryResponse($postalCodeInquiryResponse = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PostalCodeInquiryResponseType::valueIsValid($postalCodeInquiryResponse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PostalCodeInquiryResponseType', is_array($postalCodeInquiryResponse) ? implode(', ', $postalCodeInquiryResponse) : var_export($postalCodeInquiryResponse, true), implode(', ', \EnumType\PostalCodeInquiryResponseType::getValidValues())), __LINE__);
        }
        $this->PostalCodeInquiryResponse = $postalCodeInquiryResponse;
        return $this;
    }
    /**
     * Get RelatedAddressToPostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedAddressToPostalCode()
    {
        return isset($this->RelatedAddressToPostalCode) ? $this->RelatedAddressToPostalCode : null;
    }
    /**
     * Set RelatedAddressToPostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedAddressToPostalCode
     * @return \StructType\ResponseItem
     */
    public function setRelatedAddressToPostalCode($relatedAddressToPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($relatedAddressToPostalCode) && !is_string($relatedAddressToPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedAddressToPostalCode, true), gettype($relatedAddressToPostalCode)), __LINE__);
        }
        if (is_null($relatedAddressToPostalCode) || (is_array($relatedAddressToPostalCode) && empty($relatedAddressToPostalCode))) {
            unset($this->RelatedAddressToPostalCode);
        } else {
            $this->RelatedAddressToPostalCode = $relatedAddressToPostalCode;
        }
        return $this;
    }
    /**
     * Get ResponseMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseMessage()
    {
        return isset($this->ResponseMessage) ? $this->ResponseMessage : null;
    }
    /**
     * Set ResponseMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseMessage
     * @return \StructType\ResponseItem
     */
    public function setResponseMessage($responseMessage = null)
    {
        // validation for constraint: string
        if (!is_null($responseMessage) && !is_string($responseMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseMessage, true), gettype($responseMessage)), __LINE__);
        }
        if (is_null($responseMessage) || (is_array($responseMessage) && empty($responseMessage))) {
            unset($this->ResponseMessage);
        } else {
            $this->ResponseMessage = $responseMessage;
        }
        return $this;
    }
    /**
     * Get ResponseType value
     * @return string|null
     */
    public function getResponseType()
    {
        return $this->ResponseType;
    }
    /**
     * Set ResponseType value
     * @uses \EnumType\ResponseType::valueIsValid()
     * @uses \EnumType\ResponseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $responseType
     * @return \StructType\ResponseItem
     */
    public function setResponseType($responseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ResponseType::valueIsValid($responseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ResponseType', is_array($responseType) ? implode(', ', $responseType) : var_export($responseType, true), implode(', ', \EnumType\ResponseType::getValidValues())), __LINE__);
        }
        $this->ResponseType = $responseType;
        return $this;
    }
}
