<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterReceipt StructType
 * @subpackage Structs
 */
class RegisterReceipt extends AbstractStructBase
{
    /**
     * The receipt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Receipt
     */
    public $receipt;
    /**
     * Constructor method for RegisterReceipt
     * @uses RegisterReceipt::setReceipt()
     * @param \StructType\Receipt $receipt
     */
    public function __construct(\StructType\Receipt $receipt = null)
    {
        $this
            ->setReceipt($receipt);
    }
    /**
     * Get receipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Receipt|null
     */
    public function getReceipt()
    {
        return isset($this->receipt) ? $this->receipt : null;
    }
    /**
     * Set receipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Receipt $receipt
     * @return \StructType\RegisterReceipt
     */
    public function setReceipt(\StructType\Receipt $receipt = null)
    {
        if (is_null($receipt) || (is_array($receipt) && empty($receipt))) {
            unset($this->receipt);
        } else {
            $this->receipt = $receipt;
        }
        return $this;
    }
}
