<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Inquiry_TradeDocInformation StructType
 * @subpackage Structs
 */
class Inquiry_TradeDocInformation extends AbstractStructBase
{
    /**
     * The ReferenceDocumentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceDocumentNumber;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DocumentType;
    /**
     * Constructor method for Inquiry_TradeDocInformation
     * @uses Inquiry_TradeDocInformation::setReferenceDocumentNumber()
     * @uses Inquiry_TradeDocInformation::setDocumentType()
     * @param string $referenceDocumentNumber
     * @param int $documentType
     */
    public function __construct($referenceDocumentNumber = null, $documentType = null)
    {
        $this
            ->setReferenceDocumentNumber($referenceDocumentNumber)
            ->setDocumentType($documentType);
    }
    /**
     * Get ReferenceDocumentNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceDocumentNumber()
    {
        return isset($this->ReferenceDocumentNumber) ? $this->ReferenceDocumentNumber : null;
    }
    /**
     * Set ReferenceDocumentNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceDocumentNumber
     * @return \StructType\Inquiry_TradeDocInformation
     */
    public function setReferenceDocumentNumber($referenceDocumentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceDocumentNumber) && !is_string($referenceDocumentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceDocumentNumber, true), gettype($referenceDocumentNumber)), __LINE__);
        }
        if (is_null($referenceDocumentNumber) || (is_array($referenceDocumentNumber) && empty($referenceDocumentNumber))) {
            unset($this->ReferenceDocumentNumber);
        } else {
            $this->ReferenceDocumentNumber = $referenceDocumentNumber;
        }
        return $this;
    }
    /**
     * Get DocumentType value
     * @return int|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param int $documentType
     * @return \StructType\Inquiry_TradeDocInformation
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: int
        if (!is_null($documentType) && !(is_int($documentType) || ctype_digit($documentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
}
