<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Company StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Company
 * @subpackage Structs
 */
class Company extends AbstractStructBase
{
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CompanyBranch
     */
    public $Branch;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Code;
    /**
     * The LOCATION
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LOCATION;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NationalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NationalCode;
    /**
     * The SARASARY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SARASARY;
    /**
     * Constructor method for Company
     * @uses Company::setBranch()
     * @uses Company::setCode()
     * @uses Company::setLOCATION()
     * @uses Company::setName()
     * @uses Company::setNationalCode()
     * @uses Company::setSARASARY()
     * @param \StructType\CompanyBranch $branch
     * @param int $code
     * @param int $lOCATION
     * @param string $name
     * @param int $nationalCode
     * @param int $sARASARY
     */
    public function __construct(\StructType\CompanyBranch $branch = null, $code = null, $lOCATION = null, $name = null, $nationalCode = null, $sARASARY = null)
    {
        $this
            ->setBranch($branch)
            ->setCode($code)
            ->setLOCATION($lOCATION)
            ->setName($name)
            ->setNationalCode($nationalCode)
            ->setSARASARY($sARASARY);
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CompanyBranch|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CompanyBranch $branch
     * @return \StructType\Company
     */
    public function setBranch(\StructType\CompanyBranch $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get Code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\Company
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get LOCATION value
     * @return int|null
     */
    public function getLOCATION()
    {
        return $this->LOCATION;
    }
    /**
     * Set LOCATION value
     * @param int $lOCATION
     * @return \StructType\Company
     */
    public function setLOCATION($lOCATION = null)
    {
        // validation for constraint: int
        if (!is_null($lOCATION) && !(is_int($lOCATION) || ctype_digit($lOCATION))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lOCATION, true), gettype($lOCATION)), __LINE__);
        }
        $this->LOCATION = $lOCATION;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\Company
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NationalCode value
     * @return int|null
     */
    public function getNationalCode()
    {
        return $this->NationalCode;
    }
    /**
     * Set NationalCode value
     * @param int $nationalCode
     * @return \StructType\Company
     */
    public function setNationalCode($nationalCode = null)
    {
        // validation for constraint: int
        if (!is_null($nationalCode) && !(is_int($nationalCode) || ctype_digit($nationalCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nationalCode, true), gettype($nationalCode)), __LINE__);
        }
        $this->NationalCode = $nationalCode;
        return $this;
    }
    /**
     * Get SARASARY value
     * @return int|null
     */
    public function getSARASARY()
    {
        return $this->SARASARY;
    }
    /**
     * Set SARASARY value
     * @param int $sARASARY
     * @return \StructType\Company
     */
    public function setSARASARY($sARASARY = null)
    {
        // validation for constraint: int
        if (!is_null($sARASARY) && !(is_int($sARASARY) || ctype_digit($sARASARY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sARASARY, true), gettype($sARASARY)), __LINE__);
        }
        $this->SARASARY = $sARASARY;
        return $this;
    }
}
