<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillOfLadingFullInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BillOfLadingFullInfo
 * @subpackage Structs
 */
class BillOfLadingFullInfo extends AbstractStructBase
{
    /**
     * The ChangeStatusDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersianDate
     */
    public $ChangeStatusDate;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Company
     */
    public $Company;
    /**
     * The CompanyCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CompanyCommission;
    /**
     * The CompanyCommissionPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CompanyCommissionPercent;
    /**
     * The Cost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Cost;
    /**
     * The CustomInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Custom
     */
    public $CustomInfo;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The DestinationCityCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DestinationCityCode;
    /**
     * The DestinationCityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationCityName;
    /**
     * The DischargeCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DischargeCost;
    /**
     * The DriverCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DriverCommission;
    /**
     * The FirstDriver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DriverInfo
     */
    public $FirstDriver;
    /**
     * The FreighterFullInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FreighterInfo
     */
    public $FreighterFullInfo;
    /**
     * The GoodInfoList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfGoodFullInfo
     */
    public $GoodInfoList;
    /**
     * The InsuranceCompany
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InsuranceCompany;
    /**
     * The InsuranceCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InsuranceCost;
    /**
     * The InsuranceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InsuranceNumber;
    /**
     * The IssuDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersianDate
     */
    public $IssuDate;
    /**
     * The IssueTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssueTime;
    /**
     * The KalaDesc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KalaDesc;
    /**
     * The LanderTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LanderTitle;
    /**
     * The LanderTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LanderTypeCode;
    /**
     * The LoadingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LoadingCost;
    /**
     * The MasterBillofLadingTraceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MasterBillofLadingTraceCode;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Number;
    /**
     * The OriginCityCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OriginCityCode;
    /**
     * The OriginCityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginCityName;
    /**
     * The PayanehCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PayanehCost;
    /**
     * The Receiver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Person
     */
    public $Receiver;
    /**
     * The ReceiverAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceiverAddress;
    /**
     * The Robari
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Robari;
    /**
     * The Sender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Person
     */
    public $Sender;
    /**
     * The SenderAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SenderAddress;
    /**
     * The Serial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Serial;
    /**
     * The ShomarehHavalehAnbarNaft
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ShomarehHavalehAnbarNaft;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tax;
    /**
     * The TotalCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalCost;
    /**
     * The TraceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TraceCode;
    /**
     * The TransitTypeTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransitTypeTitle;
    /**
     * The TransitTypecode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransitTypecode;
    /**
     * The WeighbridgeCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $WeighbridgeCost;
    /**
     * The secondDriver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DriverInfo
     */
    public $secondDriver;
    /**
     * Constructor method for BillOfLadingFullInfo
     * @uses BillOfLadingFullInfo::setChangeStatusDate()
     * @uses BillOfLadingFullInfo::setCompany()
     * @uses BillOfLadingFullInfo::setCompanyCommission()
     * @uses BillOfLadingFullInfo::setCompanyCommissionPercent()
     * @uses BillOfLadingFullInfo::setCost()
     * @uses BillOfLadingFullInfo::setCustomInfo()
     * @uses BillOfLadingFullInfo::setDescription()
     * @uses BillOfLadingFullInfo::setDestinationCityCode()
     * @uses BillOfLadingFullInfo::setDestinationCityName()
     * @uses BillOfLadingFullInfo::setDischargeCost()
     * @uses BillOfLadingFullInfo::setDriverCommission()
     * @uses BillOfLadingFullInfo::setFirstDriver()
     * @uses BillOfLadingFullInfo::setFreighterFullInfo()
     * @uses BillOfLadingFullInfo::setGoodInfoList()
     * @uses BillOfLadingFullInfo::setInsuranceCompany()
     * @uses BillOfLadingFullInfo::setInsuranceCost()
     * @uses BillOfLadingFullInfo::setInsuranceNumber()
     * @uses BillOfLadingFullInfo::setIssuDate()
     * @uses BillOfLadingFullInfo::setIssueTime()
     * @uses BillOfLadingFullInfo::setKalaDesc()
     * @uses BillOfLadingFullInfo::setLanderTitle()
     * @uses BillOfLadingFullInfo::setLanderTypeCode()
     * @uses BillOfLadingFullInfo::setLoadingCost()
     * @uses BillOfLadingFullInfo::setMasterBillofLadingTraceCode()
     * @uses BillOfLadingFullInfo::setNumber()
     * @uses BillOfLadingFullInfo::setOriginCityCode()
     * @uses BillOfLadingFullInfo::setOriginCityName()
     * @uses BillOfLadingFullInfo::setPayanehCost()
     * @uses BillOfLadingFullInfo::setReceiver()
     * @uses BillOfLadingFullInfo::setReceiverAddress()
     * @uses BillOfLadingFullInfo::setRobari()
     * @uses BillOfLadingFullInfo::setSender()
     * @uses BillOfLadingFullInfo::setSenderAddress()
     * @uses BillOfLadingFullInfo::setSerial()
     * @uses BillOfLadingFullInfo::setShomarehHavalehAnbarNaft()
     * @uses BillOfLadingFullInfo::setStatus()
     * @uses BillOfLadingFullInfo::setTax()
     * @uses BillOfLadingFullInfo::setTotalCost()
     * @uses BillOfLadingFullInfo::setTraceCode()
     * @uses BillOfLadingFullInfo::setTransitTypeTitle()
     * @uses BillOfLadingFullInfo::setTransitTypecode()
     * @uses BillOfLadingFullInfo::setWeighbridgeCost()
     * @uses BillOfLadingFullInfo::setSecondDriver()
     * @param \StructType\PersianDate $changeStatusDate
     * @param \StructType\Company $company
     * @param float $companyCommission
     * @param float $companyCommissionPercent
     * @param int $cost
     * @param \StructType\Custom $customInfo
     * @param string $description
     * @param int $destinationCityCode
     * @param string $destinationCityName
     * @param int $dischargeCost
     * @param int $driverCommission
     * @param \StructType\DriverInfo $firstDriver
     * @param \StructType\FreighterInfo $freighterFullInfo
     * @param \ArrayType\ArrayOfGoodFullInfo $goodInfoList
     * @param string $insuranceCompany
     * @param int $insuranceCost
     * @param string $insuranceNumber
     * @param \StructType\PersianDate $issuDate
     * @param string $issueTime
     * @param string $kalaDesc
     * @param string $landerTitle
     * @param int $landerTypeCode
     * @param int $loadingCost
     * @param string $masterBillofLadingTraceCode
     * @param int $number
     * @param int $originCityCode
     * @param string $originCityName
     * @param int $payanehCost
     * @param \StructType\Person $receiver
     * @param string $receiverAddress
     * @param bool $robari
     * @param \StructType\Person $sender
     * @param string $senderAddress
     * @param string $serial
     * @param int $shomarehHavalehAnbarNaft
     * @param string $status
     * @param int $tax
     * @param float $totalCost
     * @param string $traceCode
     * @param string $transitTypeTitle
     * @param int $transitTypecode
     * @param int $weighbridgeCost
     * @param \StructType\DriverInfo $secondDriver
     */
    public function __construct(\StructType\PersianDate $changeStatusDate = null, \StructType\Company $company = null, $companyCommission = null, $companyCommissionPercent = null, $cost = null, \StructType\Custom $customInfo = null, $description = null, $destinationCityCode = null, $destinationCityName = null, $dischargeCost = null, $driverCommission = null, \StructType\DriverInfo $firstDriver = null, \StructType\FreighterInfo $freighterFullInfo = null, \ArrayType\ArrayOfGoodFullInfo $goodInfoList = null, $insuranceCompany = null, $insuranceCost = null, $insuranceNumber = null, \StructType\PersianDate $issuDate = null, $issueTime = null, $kalaDesc = null, $landerTitle = null, $landerTypeCode = null, $loadingCost = null, $masterBillofLadingTraceCode = null, $number = null, $originCityCode = null, $originCityName = null, $payanehCost = null, \StructType\Person $receiver = null, $receiverAddress = null, $robari = null, \StructType\Person $sender = null, $senderAddress = null, $serial = null, $shomarehHavalehAnbarNaft = null, $status = null, $tax = null, $totalCost = null, $traceCode = null, $transitTypeTitle = null, $transitTypecode = null, $weighbridgeCost = null, \StructType\DriverInfo $secondDriver = null)
    {
        $this
            ->setChangeStatusDate($changeStatusDate)
            ->setCompany($company)
            ->setCompanyCommission($companyCommission)
            ->setCompanyCommissionPercent($companyCommissionPercent)
            ->setCost($cost)
            ->setCustomInfo($customInfo)
            ->setDescription($description)
            ->setDestinationCityCode($destinationCityCode)
            ->setDestinationCityName($destinationCityName)
            ->setDischargeCost($dischargeCost)
            ->setDriverCommission($driverCommission)
            ->setFirstDriver($firstDriver)
            ->setFreighterFullInfo($freighterFullInfo)
            ->setGoodInfoList($goodInfoList)
            ->setInsuranceCompany($insuranceCompany)
            ->setInsuranceCost($insuranceCost)
            ->setInsuranceNumber($insuranceNumber)
            ->setIssuDate($issuDate)
            ->setIssueTime($issueTime)
            ->setKalaDesc($kalaDesc)
            ->setLanderTitle($landerTitle)
            ->setLanderTypeCode($landerTypeCode)
            ->setLoadingCost($loadingCost)
            ->setMasterBillofLadingTraceCode($masterBillofLadingTraceCode)
            ->setNumber($number)
            ->setOriginCityCode($originCityCode)
            ->setOriginCityName($originCityName)
            ->setPayanehCost($payanehCost)
            ->setReceiver($receiver)
            ->setReceiverAddress($receiverAddress)
            ->setRobari($robari)
            ->setSender($sender)
            ->setSenderAddress($senderAddress)
            ->setSerial($serial)
            ->setShomarehHavalehAnbarNaft($shomarehHavalehAnbarNaft)
            ->setStatus($status)
            ->setTax($tax)
            ->setTotalCost($totalCost)
            ->setTraceCode($traceCode)
            ->setTransitTypeTitle($transitTypeTitle)
            ->setTransitTypecode($transitTypecode)
            ->setWeighbridgeCost($weighbridgeCost)
            ->setSecondDriver($secondDriver);
    }
    /**
     * Get ChangeStatusDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersianDate|null
     */
    public function getChangeStatusDate()
    {
        return isset($this->ChangeStatusDate) ? $this->ChangeStatusDate : null;
    }
    /**
     * Set ChangeStatusDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PersianDate $changeStatusDate
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setChangeStatusDate(\StructType\PersianDate $changeStatusDate = null)
    {
        if (is_null($changeStatusDate) || (is_array($changeStatusDate) && empty($changeStatusDate))) {
            unset($this->ChangeStatusDate);
        } else {
            $this->ChangeStatusDate = $changeStatusDate;
        }
        return $this;
    }
    /**
     * Get Company value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Company|null
     */
    public function getCompany()
    {
        return isset($this->Company) ? $this->Company : null;
    }
    /**
     * Set Company value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Company $company
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setCompany(\StructType\Company $company = null)
    {
        if (is_null($company) || (is_array($company) && empty($company))) {
            unset($this->Company);
        } else {
            $this->Company = $company;
        }
        return $this;
    }
    /**
     * Get CompanyCommission value
     * @return float|null
     */
    public function getCompanyCommission()
    {
        return $this->CompanyCommission;
    }
    /**
     * Set CompanyCommission value
     * @param float $companyCommission
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setCompanyCommission($companyCommission = null)
    {
        // validation for constraint: float
        if (!is_null($companyCommission) && !(is_float($companyCommission) || is_numeric($companyCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($companyCommission, true), gettype($companyCommission)), __LINE__);
        }
        $this->CompanyCommission = $companyCommission;
        return $this;
    }
    /**
     * Get CompanyCommissionPercent value
     * @return float|null
     */
    public function getCompanyCommissionPercent()
    {
        return $this->CompanyCommissionPercent;
    }
    /**
     * Set CompanyCommissionPercent value
     * @param float $companyCommissionPercent
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setCompanyCommissionPercent($companyCommissionPercent = null)
    {
        // validation for constraint: float
        if (!is_null($companyCommissionPercent) && !(is_float($companyCommissionPercent) || is_numeric($companyCommissionPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($companyCommissionPercent, true), gettype($companyCommissionPercent)), __LINE__);
        }
        $this->CompanyCommissionPercent = $companyCommissionPercent;
        return $this;
    }
    /**
     * Get Cost value
     * @return int|null
     */
    public function getCost()
    {
        return $this->Cost;
    }
    /**
     * Set Cost value
     * @param int $cost
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setCost($cost = null)
    {
        // validation for constraint: int
        if (!is_null($cost) && !(is_int($cost) || ctype_digit($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->Cost = $cost;
        return $this;
    }
    /**
     * Get CustomInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Custom|null
     */
    public function getCustomInfo()
    {
        return isset($this->CustomInfo) ? $this->CustomInfo : null;
    }
    /**
     * Set CustomInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Custom $customInfo
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setCustomInfo(\StructType\Custom $customInfo = null)
    {
        if (is_null($customInfo) || (is_array($customInfo) && empty($customInfo))) {
            unset($this->CustomInfo);
        } else {
            $this->CustomInfo = $customInfo;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DestinationCityCode value
     * @return int|null
     */
    public function getDestinationCityCode()
    {
        return $this->DestinationCityCode;
    }
    /**
     * Set DestinationCityCode value
     * @param int $destinationCityCode
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setDestinationCityCode($destinationCityCode = null)
    {
        // validation for constraint: int
        if (!is_null($destinationCityCode) && !(is_int($destinationCityCode) || ctype_digit($destinationCityCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destinationCityCode, true), gettype($destinationCityCode)), __LINE__);
        }
        $this->DestinationCityCode = $destinationCityCode;
        return $this;
    }
    /**
     * Get DestinationCityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationCityName()
    {
        return isset($this->DestinationCityName) ? $this->DestinationCityName : null;
    }
    /**
     * Set DestinationCityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationCityName
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setDestinationCityName($destinationCityName = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCityName) && !is_string($destinationCityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCityName, true), gettype($destinationCityName)), __LINE__);
        }
        if (is_null($destinationCityName) || (is_array($destinationCityName) && empty($destinationCityName))) {
            unset($this->DestinationCityName);
        } else {
            $this->DestinationCityName = $destinationCityName;
        }
        return $this;
    }
    /**
     * Get DischargeCost value
     * @return int|null
     */
    public function getDischargeCost()
    {
        return $this->DischargeCost;
    }
    /**
     * Set DischargeCost value
     * @param int $dischargeCost
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setDischargeCost($dischargeCost = null)
    {
        // validation for constraint: int
        if (!is_null($dischargeCost) && !(is_int($dischargeCost) || ctype_digit($dischargeCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dischargeCost, true), gettype($dischargeCost)), __LINE__);
        }
        $this->DischargeCost = $dischargeCost;
        return $this;
    }
    /**
     * Get DriverCommission value
     * @return int|null
     */
    public function getDriverCommission()
    {
        return $this->DriverCommission;
    }
    /**
     * Set DriverCommission value
     * @param int $driverCommission
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setDriverCommission($driverCommission = null)
    {
        // validation for constraint: int
        if (!is_null($driverCommission) && !(is_int($driverCommission) || ctype_digit($driverCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($driverCommission, true), gettype($driverCommission)), __LINE__);
        }
        $this->DriverCommission = $driverCommission;
        return $this;
    }
    /**
     * Get FirstDriver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DriverInfo|null
     */
    public function getFirstDriver()
    {
        return isset($this->FirstDriver) ? $this->FirstDriver : null;
    }
    /**
     * Set FirstDriver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DriverInfo $firstDriver
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setFirstDriver(\StructType\DriverInfo $firstDriver = null)
    {
        if (is_null($firstDriver) || (is_array($firstDriver) && empty($firstDriver))) {
            unset($this->FirstDriver);
        } else {
            $this->FirstDriver = $firstDriver;
        }
        return $this;
    }
    /**
     * Get FreighterFullInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FreighterInfo|null
     */
    public function getFreighterFullInfo()
    {
        return isset($this->FreighterFullInfo) ? $this->FreighterFullInfo : null;
    }
    /**
     * Set FreighterFullInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FreighterInfo $freighterFullInfo
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setFreighterFullInfo(\StructType\FreighterInfo $freighterFullInfo = null)
    {
        if (is_null($freighterFullInfo) || (is_array($freighterFullInfo) && empty($freighterFullInfo))) {
            unset($this->FreighterFullInfo);
        } else {
            $this->FreighterFullInfo = $freighterFullInfo;
        }
        return $this;
    }
    /**
     * Get GoodInfoList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfGoodFullInfo|null
     */
    public function getGoodInfoList()
    {
        return isset($this->GoodInfoList) ? $this->GoodInfoList : null;
    }
    /**
     * Set GoodInfoList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfGoodFullInfo $goodInfoList
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setGoodInfoList(\ArrayType\ArrayOfGoodFullInfo $goodInfoList = null)
    {
        if (is_null($goodInfoList) || (is_array($goodInfoList) && empty($goodInfoList))) {
            unset($this->GoodInfoList);
        } else {
            $this->GoodInfoList = $goodInfoList;
        }
        return $this;
    }
    /**
     * Get InsuranceCompany value
     * @return string|null
     */
    public function getInsuranceCompany()
    {
        return $this->InsuranceCompany;
    }
    /**
     * Set InsuranceCompany value
     * @uses \EnumType\InsuranceCompanyEnum::valueIsValid()
     * @uses \EnumType\InsuranceCompanyEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insuranceCompany
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setInsuranceCompany($insuranceCompany = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InsuranceCompanyEnum::valueIsValid($insuranceCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InsuranceCompanyEnum', is_array($insuranceCompany) ? implode(', ', $insuranceCompany) : var_export($insuranceCompany, true), implode(', ', \EnumType\InsuranceCompanyEnum::getValidValues())), __LINE__);
        }
        $this->InsuranceCompany = $insuranceCompany;
        return $this;
    }
    /**
     * Get InsuranceCost value
     * @return int|null
     */
    public function getInsuranceCost()
    {
        return $this->InsuranceCost;
    }
    /**
     * Set InsuranceCost value
     * @param int $insuranceCost
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setInsuranceCost($insuranceCost = null)
    {
        // validation for constraint: int
        if (!is_null($insuranceCost) && !(is_int($insuranceCost) || ctype_digit($insuranceCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insuranceCost, true), gettype($insuranceCost)), __LINE__);
        }
        $this->InsuranceCost = $insuranceCost;
        return $this;
    }
    /**
     * Get InsuranceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsuranceNumber()
    {
        return isset($this->InsuranceNumber) ? $this->InsuranceNumber : null;
    }
    /**
     * Set InsuranceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $insuranceNumber
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setInsuranceNumber($insuranceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceNumber) && !is_string($insuranceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insuranceNumber, true), gettype($insuranceNumber)), __LINE__);
        }
        if (is_null($insuranceNumber) || (is_array($insuranceNumber) && empty($insuranceNumber))) {
            unset($this->InsuranceNumber);
        } else {
            $this->InsuranceNumber = $insuranceNumber;
        }
        return $this;
    }
    /**
     * Get IssuDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersianDate|null
     */
    public function getIssuDate()
    {
        return isset($this->IssuDate) ? $this->IssuDate : null;
    }
    /**
     * Set IssuDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PersianDate $issuDate
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setIssuDate(\StructType\PersianDate $issuDate = null)
    {
        if (is_null($issuDate) || (is_array($issuDate) && empty($issuDate))) {
            unset($this->IssuDate);
        } else {
            $this->IssuDate = $issuDate;
        }
        return $this;
    }
    /**
     * Get IssueTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssueTime()
    {
        return isset($this->IssueTime) ? $this->IssueTime : null;
    }
    /**
     * Set IssueTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issueTime
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setIssueTime($issueTime = null)
    {
        // validation for constraint: string
        if (!is_null($issueTime) && !is_string($issueTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueTime, true), gettype($issueTime)), __LINE__);
        }
        if (is_null($issueTime) || (is_array($issueTime) && empty($issueTime))) {
            unset($this->IssueTime);
        } else {
            $this->IssueTime = $issueTime;
        }
        return $this;
    }
    /**
     * Get KalaDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKalaDesc()
    {
        return isset($this->KalaDesc) ? $this->KalaDesc : null;
    }
    /**
     * Set KalaDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kalaDesc
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setKalaDesc($kalaDesc = null)
    {
        // validation for constraint: string
        if (!is_null($kalaDesc) && !is_string($kalaDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kalaDesc, true), gettype($kalaDesc)), __LINE__);
        }
        if (is_null($kalaDesc) || (is_array($kalaDesc) && empty($kalaDesc))) {
            unset($this->KalaDesc);
        } else {
            $this->KalaDesc = $kalaDesc;
        }
        return $this;
    }
    /**
     * Get LanderTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanderTitle()
    {
        return isset($this->LanderTitle) ? $this->LanderTitle : null;
    }
    /**
     * Set LanderTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $landerTitle
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setLanderTitle($landerTitle = null)
    {
        // validation for constraint: string
        if (!is_null($landerTitle) && !is_string($landerTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($landerTitle, true), gettype($landerTitle)), __LINE__);
        }
        if (is_null($landerTitle) || (is_array($landerTitle) && empty($landerTitle))) {
            unset($this->LanderTitle);
        } else {
            $this->LanderTitle = $landerTitle;
        }
        return $this;
    }
    /**
     * Get LanderTypeCode value
     * @return int|null
     */
    public function getLanderTypeCode()
    {
        return $this->LanderTypeCode;
    }
    /**
     * Set LanderTypeCode value
     * @param int $landerTypeCode
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setLanderTypeCode($landerTypeCode = null)
    {
        // validation for constraint: int
        if (!is_null($landerTypeCode) && !(is_int($landerTypeCode) || ctype_digit($landerTypeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($landerTypeCode, true), gettype($landerTypeCode)), __LINE__);
        }
        $this->LanderTypeCode = $landerTypeCode;
        return $this;
    }
    /**
     * Get LoadingCost value
     * @return int|null
     */
    public function getLoadingCost()
    {
        return $this->LoadingCost;
    }
    /**
     * Set LoadingCost value
     * @param int $loadingCost
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setLoadingCost($loadingCost = null)
    {
        // validation for constraint: int
        if (!is_null($loadingCost) && !(is_int($loadingCost) || ctype_digit($loadingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loadingCost, true), gettype($loadingCost)), __LINE__);
        }
        $this->LoadingCost = $loadingCost;
        return $this;
    }
    /**
     * Get MasterBillofLadingTraceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterBillofLadingTraceCode()
    {
        return isset($this->MasterBillofLadingTraceCode) ? $this->MasterBillofLadingTraceCode : null;
    }
    /**
     * Set MasterBillofLadingTraceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterBillofLadingTraceCode
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setMasterBillofLadingTraceCode($masterBillofLadingTraceCode = null)
    {
        // validation for constraint: string
        if (!is_null($masterBillofLadingTraceCode) && !is_string($masterBillofLadingTraceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterBillofLadingTraceCode, true), gettype($masterBillofLadingTraceCode)), __LINE__);
        }
        if (is_null($masterBillofLadingTraceCode) || (is_array($masterBillofLadingTraceCode) && empty($masterBillofLadingTraceCode))) {
            unset($this->MasterBillofLadingTraceCode);
        } else {
            $this->MasterBillofLadingTraceCode = $masterBillofLadingTraceCode;
        }
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get OriginCityCode value
     * @return int|null
     */
    public function getOriginCityCode()
    {
        return $this->OriginCityCode;
    }
    /**
     * Set OriginCityCode value
     * @param int $originCityCode
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setOriginCityCode($originCityCode = null)
    {
        // validation for constraint: int
        if (!is_null($originCityCode) && !(is_int($originCityCode) || ctype_digit($originCityCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originCityCode, true), gettype($originCityCode)), __LINE__);
        }
        $this->OriginCityCode = $originCityCode;
        return $this;
    }
    /**
     * Get OriginCityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginCityName()
    {
        return isset($this->OriginCityName) ? $this->OriginCityName : null;
    }
    /**
     * Set OriginCityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originCityName
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setOriginCityName($originCityName = null)
    {
        // validation for constraint: string
        if (!is_null($originCityName) && !is_string($originCityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCityName, true), gettype($originCityName)), __LINE__);
        }
        if (is_null($originCityName) || (is_array($originCityName) && empty($originCityName))) {
            unset($this->OriginCityName);
        } else {
            $this->OriginCityName = $originCityName;
        }
        return $this;
    }
    /**
     * Get PayanehCost value
     * @return int|null
     */
    public function getPayanehCost()
    {
        return $this->PayanehCost;
    }
    /**
     * Set PayanehCost value
     * @param int $payanehCost
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setPayanehCost($payanehCost = null)
    {
        // validation for constraint: int
        if (!is_null($payanehCost) && !(is_int($payanehCost) || ctype_digit($payanehCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payanehCost, true), gettype($payanehCost)), __LINE__);
        }
        $this->PayanehCost = $payanehCost;
        return $this;
    }
    /**
     * Get Receiver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Person|null
     */
    public function getReceiver()
    {
        return isset($this->Receiver) ? $this->Receiver : null;
    }
    /**
     * Set Receiver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Person $receiver
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setReceiver(\StructType\Person $receiver = null)
    {
        if (is_null($receiver) || (is_array($receiver) && empty($receiver))) {
            unset($this->Receiver);
        } else {
            $this->Receiver = $receiver;
        }
        return $this;
    }
    /**
     * Get ReceiverAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceiverAddress()
    {
        return isset($this->ReceiverAddress) ? $this->ReceiverAddress : null;
    }
    /**
     * Set ReceiverAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receiverAddress
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setReceiverAddress($receiverAddress = null)
    {
        // validation for constraint: string
        if (!is_null($receiverAddress) && !is_string($receiverAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverAddress, true), gettype($receiverAddress)), __LINE__);
        }
        if (is_null($receiverAddress) || (is_array($receiverAddress) && empty($receiverAddress))) {
            unset($this->ReceiverAddress);
        } else {
            $this->ReceiverAddress = $receiverAddress;
        }
        return $this;
    }
    /**
     * Get Robari value
     * @return bool|null
     */
    public function getRobari()
    {
        return $this->Robari;
    }
    /**
     * Set Robari value
     * @param bool $robari
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setRobari($robari = null)
    {
        // validation for constraint: boolean
        if (!is_null($robari) && !is_bool($robari)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($robari, true), gettype($robari)), __LINE__);
        }
        $this->Robari = $robari;
        return $this;
    }
    /**
     * Get Sender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Person|null
     */
    public function getSender()
    {
        return isset($this->Sender) ? $this->Sender : null;
    }
    /**
     * Set Sender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Person $sender
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setSender(\StructType\Person $sender = null)
    {
        if (is_null($sender) || (is_array($sender) && empty($sender))) {
            unset($this->Sender);
        } else {
            $this->Sender = $sender;
        }
        return $this;
    }
    /**
     * Get SenderAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderAddress()
    {
        return isset($this->SenderAddress) ? $this->SenderAddress : null;
    }
    /**
     * Set SenderAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderAddress
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setSenderAddress($senderAddress = null)
    {
        // validation for constraint: string
        if (!is_null($senderAddress) && !is_string($senderAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderAddress, true), gettype($senderAddress)), __LINE__);
        }
        if (is_null($senderAddress) || (is_array($senderAddress) && empty($senderAddress))) {
            unset($this->SenderAddress);
        } else {
            $this->SenderAddress = $senderAddress;
        }
        return $this;
    }
    /**
     * Get Serial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerial()
    {
        return isset($this->Serial) ? $this->Serial : null;
    }
    /**
     * Set Serial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serial
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setSerial($serial = null)
    {
        // validation for constraint: string
        if (!is_null($serial) && !is_string($serial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serial, true), gettype($serial)), __LINE__);
        }
        if (is_null($serial) || (is_array($serial) && empty($serial))) {
            unset($this->Serial);
        } else {
            $this->Serial = $serial;
        }
        return $this;
    }
    /**
     * Get ShomarehHavalehAnbarNaft value
     * @return int|null
     */
    public function getShomarehHavalehAnbarNaft()
    {
        return $this->ShomarehHavalehAnbarNaft;
    }
    /**
     * Set ShomarehHavalehAnbarNaft value
     * @param int $shomarehHavalehAnbarNaft
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setShomarehHavalehAnbarNaft($shomarehHavalehAnbarNaft = null)
    {
        // validation for constraint: int
        if (!is_null($shomarehHavalehAnbarNaft) && !(is_int($shomarehHavalehAnbarNaft) || ctype_digit($shomarehHavalehAnbarNaft))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shomarehHavalehAnbarNaft, true), gettype($shomarehHavalehAnbarNaft)), __LINE__);
        }
        $this->ShomarehHavalehAnbarNaft = $shomarehHavalehAnbarNaft;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\BillOfLadingStatus::valueIsValid()
     * @uses \EnumType\BillOfLadingStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BillOfLadingStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BillOfLadingStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\BillOfLadingStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Tax value
     * @return int|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param int $tax
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setTax($tax = null)
    {
        // validation for constraint: int
        if (!is_null($tax) && !(is_int($tax) || ctype_digit($tax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tax, true), gettype($tax)), __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get TotalCost value
     * @return float|null
     */
    public function getTotalCost()
    {
        return $this->TotalCost;
    }
    /**
     * Set TotalCost value
     * @param float $totalCost
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setTotalCost($totalCost = null)
    {
        // validation for constraint: float
        if (!is_null($totalCost) && !(is_float($totalCost) || is_numeric($totalCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCost, true), gettype($totalCost)), __LINE__);
        }
        $this->TotalCost = $totalCost;
        return $this;
    }
    /**
     * Get TraceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTraceCode()
    {
        return isset($this->TraceCode) ? $this->TraceCode : null;
    }
    /**
     * Set TraceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $traceCode
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setTraceCode($traceCode = null)
    {
        // validation for constraint: string
        if (!is_null($traceCode) && !is_string($traceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traceCode, true), gettype($traceCode)), __LINE__);
        }
        if (is_null($traceCode) || (is_array($traceCode) && empty($traceCode))) {
            unset($this->TraceCode);
        } else {
            $this->TraceCode = $traceCode;
        }
        return $this;
    }
    /**
     * Get TransitTypeTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransitTypeTitle()
    {
        return isset($this->TransitTypeTitle) ? $this->TransitTypeTitle : null;
    }
    /**
     * Set TransitTypeTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transitTypeTitle
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setTransitTypeTitle($transitTypeTitle = null)
    {
        // validation for constraint: string
        if (!is_null($transitTypeTitle) && !is_string($transitTypeTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transitTypeTitle, true), gettype($transitTypeTitle)), __LINE__);
        }
        if (is_null($transitTypeTitle) || (is_array($transitTypeTitle) && empty($transitTypeTitle))) {
            unset($this->TransitTypeTitle);
        } else {
            $this->TransitTypeTitle = $transitTypeTitle;
        }
        return $this;
    }
    /**
     * Get TransitTypecode value
     * @return int|null
     */
    public function getTransitTypecode()
    {
        return $this->TransitTypecode;
    }
    /**
     * Set TransitTypecode value
     * @param int $transitTypecode
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setTransitTypecode($transitTypecode = null)
    {
        // validation for constraint: int
        if (!is_null($transitTypecode) && !(is_int($transitTypecode) || ctype_digit($transitTypecode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transitTypecode, true), gettype($transitTypecode)), __LINE__);
        }
        $this->TransitTypecode = $transitTypecode;
        return $this;
    }
    /**
     * Get WeighbridgeCost value
     * @return int|null
     */
    public function getWeighbridgeCost()
    {
        return $this->WeighbridgeCost;
    }
    /**
     * Set WeighbridgeCost value
     * @param int $weighbridgeCost
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setWeighbridgeCost($weighbridgeCost = null)
    {
        // validation for constraint: int
        if (!is_null($weighbridgeCost) && !(is_int($weighbridgeCost) || ctype_digit($weighbridgeCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($weighbridgeCost, true), gettype($weighbridgeCost)), __LINE__);
        }
        $this->WeighbridgeCost = $weighbridgeCost;
        return $this;
    }
    /**
     * Get secondDriver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DriverInfo|null
     */
    public function getSecondDriver()
    {
        return isset($this->secondDriver) ? $this->secondDriver : null;
    }
    /**
     * Set secondDriver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DriverInfo $secondDriver
     * @return \StructType\BillOfLadingFullInfo
     */
    public function setSecondDriver(\StructType\DriverInfo $secondDriver = null)
    {
        if (is_null($secondDriver) || (is_array($secondDriver) && empty($secondDriver))) {
            unset($this->secondDriver);
        } else {
            $this->secondDriver = $secondDriver;
        }
        return $this;
    }
}
