<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGoodInfo ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfGoodInfo
 * @subpackage Arrays
 */
class ArrayOfGoodInfo extends AbstractStructArrayBase
{
    /**
     * The GoodInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GoodInfo[]
     */
    public $GoodInfo;
    /**
     * Constructor method for ArrayOfGoodInfo
     * @uses ArrayOfGoodInfo::setGoodInfo()
     * @param \StructType\GoodInfo[] $goodInfo
     */
    public function __construct(array $goodInfo = array())
    {
        $this
            ->setGoodInfo($goodInfo);
    }
    /**
     * Get GoodInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GoodInfo[]|null
     */
    public function getGoodInfo()
    {
        return isset($this->GoodInfo) ? $this->GoodInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGoodInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoodInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoodInfoForArrayConstraintsFromSetGoodInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfGoodInfoGoodInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfGoodInfoGoodInfoItem instanceof \StructType\GoodInfo) {
                $invalidValues[] = is_object($arrayOfGoodInfoGoodInfoItem) ? get_class($arrayOfGoodInfoGoodInfoItem) : sprintf('%s(%s)', gettype($arrayOfGoodInfoGoodInfoItem), var_export($arrayOfGoodInfoGoodInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GoodInfo property can only contain items of type \StructType\GoodInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GoodInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GoodInfo[] $goodInfo
     * @return \ArrayType\ArrayOfGoodInfo
     */
    public function setGoodInfo(array $goodInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($goodInfoArrayErrorMessage = self::validateGoodInfoForArrayConstraintsFromSetGoodInfo($goodInfo))) {
            throw new \InvalidArgumentException($goodInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($goodInfo) || (is_array($goodInfo) && empty($goodInfo))) {
            unset($this->GoodInfo);
        } else {
            $this->GoodInfo = $goodInfo;
        }
        return $this;
    }
    /**
     * Add item to GoodInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\GoodInfo $item
     * @return \ArrayType\ArrayOfGoodInfo
     */
    public function addToGoodInfo(\StructType\GoodInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GoodInfo) {
            throw new \InvalidArgumentException(sprintf('The GoodInfo property can only contain items of type \StructType\GoodInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GoodInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GoodInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GoodInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GoodInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GoodInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GoodInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GoodInfo
     */
    public function getAttributeName()
    {
        return 'GoodInfo';
    }
}
