<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://campaign.api.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v13/CampaignManagementService.svc?singleWsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://campaign.api.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v13/CampaignManagementService.svc?singleWsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
$add->setSoapHeaderApplicationToken($ApplicationToken);
$add->setSoapHeaderAuthenticationToken($AuthenticationToken);
$add->setSoapHeaderCustomerAccountId($CustomerAccountId);
$add->setSoapHeaderCustomerId($CustomerId);
$add->setSoapHeaderDeveloperToken($DeveloperToken);
$add->setSoapHeaderPassword($Password);
$add->setSoapHeaderUserName($UserName);
/**
 * Sample call for AddCampaigns operation/method
 */
if ($add->AddCampaigns(new \StructType\AddCampaignsRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddAdGroups operation/method
 */
if ($add->AddAdGroups(new \StructType\AddAdGroupsRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddAds operation/method
 */
if ($add->AddAds(new \StructType\AddAdsRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddKeywords operation/method
 */
if ($add->AddKeywords(new \StructType\AddKeywordsRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddAdExtensions operation/method
 */
if ($add->AddAdExtensions(new \StructType\AddAdExtensionsRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMedia operation/method
 */
if ($add->AddMedia(new \StructType\AddMediaRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddAdGroupCriterions operation/method
 */
if ($add->AddAdGroupCriterions(new \StructType\AddAdGroupCriterionsRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddNegativeKeywordsToEntities operation/method
 */
if ($add->AddNegativeKeywordsToEntities(new \StructType\AddNegativeKeywordsToEntitiesRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSharedEntity operation/method
 */
if ($add->AddSharedEntity(new \StructType\AddSharedEntityRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddListItemsToSharedList operation/method
 */
if ($add->AddListItemsToSharedList(new \StructType\AddListItemsToSharedListRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddCampaignCriterions operation/method
 */
if ($add->AddCampaignCriterions(new \StructType\AddCampaignCriterionsRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddBudgets operation/method
 */
if ($add->AddBudgets(new \StructType\AddBudgetsRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddBidStrategies operation/method
 */
if ($add->AddBidStrategies(new \StructType\AddBidStrategiesRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddAudiences operation/method
 */
if ($add->AddAudiences(new \StructType\AddAudiencesRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUetTags operation/method
 */
if ($add->AddUetTags(new \StructType\AddUetTagsRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddConversionGoals operation/method
 */
if ($add->AddConversionGoals(new \StructType\AddConversionGoalsRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddLabels operation/method
 */
if ($add->AddLabels(new \StructType\AddLabelsRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddExperiments operation/method
 */
if ($add->AddExperiments(new \StructType\AddExperimentsRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddImportJobs operation/method
 */
if ($add->AddImportJobs(new \StructType\AddImportJobsRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddVideos operation/method
 */
if ($add->AddVideos(new \StructType\AddVideosRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderApplicationToken($ApplicationToken);
$get->setSoapHeaderAuthenticationToken($AuthenticationToken);
$get->setSoapHeaderCustomerAccountId($CustomerAccountId);
$get->setSoapHeaderCustomerId($CustomerId);
$get->setSoapHeaderDeveloperToken($DeveloperToken);
$get->setSoapHeaderPassword($Password);
$get->setSoapHeaderUserName($UserName);
/**
 * Sample call for GetCampaignsByAccountId operation/method
 */
if ($get->GetCampaignsByAccountId(new \StructType\GetCampaignsByAccountIdRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCampaignsByIds operation/method
 */
if ($get->GetCampaignsByIds(new \StructType\GetCampaignsByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNegativeSitesByCampaignIds operation/method
 */
if ($get->GetNegativeSitesByCampaignIds(new \StructType\GetNegativeSitesByCampaignIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetConfigValue operation/method
 */
if ($get->GetConfigValue(new \StructType\GetConfigValueRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBSCCountries operation/method
 */
if ($get->GetBSCCountries(new \StructType\GetBSCCountriesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAdGroupsByIds operation/method
 */
if ($get->GetAdGroupsByIds(new \StructType\GetAdGroupsByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAdGroupsByCampaignId operation/method
 */
if ($get->GetAdGroupsByCampaignId(new \StructType\GetAdGroupsByCampaignIdRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNegativeSitesByAdGroupIds operation/method
 */
if ($get->GetNegativeSitesByAdGroupIds(new \StructType\GetNegativeSitesByAdGroupIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGeoLocationsFileUrl operation/method
 */
if ($get->GetGeoLocationsFileUrl(new \StructType\GetGeoLocationsFileUrlRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAdsByEditorialStatus operation/method
 */
if ($get->GetAdsByEditorialStatus(new \StructType\GetAdsByEditorialStatusRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAdsByIds operation/method
 */
if ($get->GetAdsByIds(new \StructType\GetAdsByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAdsByAdGroupId operation/method
 */
if ($get->GetAdsByAdGroupId(new \StructType\GetAdsByAdGroupIdRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetKeywordsByEditorialStatus operation/method
 */
if ($get->GetKeywordsByEditorialStatus(new \StructType\GetKeywordsByEditorialStatusRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetKeywordsByIds operation/method
 */
if ($get->GetKeywordsByIds(new \StructType\GetKeywordsByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetKeywordsByAdGroupId operation/method
 */
if ($get->GetKeywordsByAdGroupId(new \StructType\GetKeywordsByAdGroupIdRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEditorialReasonsByIds operation/method
 */
if ($get->GetEditorialReasonsByIds(new \StructType\GetEditorialReasonsByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccountMigrationStatuses operation/method
 */
if ($get->GetAccountMigrationStatuses(new \StructType\GetAccountMigrationStatusesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccountProperties operation/method
 */
if ($get->GetAccountProperties(new \StructType\GetAccountPropertiesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAdExtensionsByIds operation/method
 */
if ($get->GetAdExtensionsByIds(new \StructType\GetAdExtensionsByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAdExtensionsEditorialReasons operation/method
 */
if ($get->GetAdExtensionsEditorialReasons(new \StructType\GetAdExtensionsEditorialReasonsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAdExtensionsAssociations operation/method
 */
if ($get->GetAdExtensionsAssociations(new \StructType\GetAdExtensionsAssociationsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAdExtensionIdsByAccountId operation/method
 */
if ($get->GetAdExtensionIdsByAccountId(new \StructType\GetAdExtensionIdsByAccountIdRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMediaMetaDataByAccountId operation/method
 */
if ($get->GetMediaMetaDataByAccountId(new \StructType\GetMediaMetaDataByAccountIdRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMediaMetaDataByIds operation/method
 */
if ($get->GetMediaMetaDataByIds(new \StructType\GetMediaMetaDataByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMediaAssociations operation/method
 */
if ($get->GetMediaAssociations(new \StructType\GetMediaAssociationsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAdGroupCriterionsByIds operation/method
 */
if ($get->GetAdGroupCriterionsByIds(new \StructType\GetAdGroupCriterionsByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBMCStoresByCustomerId operation/method
 */
if ($get->GetBMCStoresByCustomerId(new \StructType\GetBMCStoresByCustomerIdRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNegativeKeywordsByEntityIds operation/method
 */
if ($get->GetNegativeKeywordsByEntityIds(new \StructType\GetNegativeKeywordsByEntityIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSharedEntitiesByAccountId operation/method
 */
if ($get->GetSharedEntitiesByAccountId(new \StructType\GetSharedEntitiesByAccountIdRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSharedEntities operation/method
 */
if ($get->GetSharedEntities(new \StructType\GetSharedEntitiesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetListItemsBySharedList operation/method
 */
if ($get->GetListItemsBySharedList(new \StructType\GetListItemsBySharedListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSharedEntityAssociationsBySharedEntityIds operation/method
 */
if ($get->GetSharedEntityAssociationsBySharedEntityIds(new \StructType\GetSharedEntityAssociationsBySharedEntityIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSharedEntityAssociationsByEntityIds operation/method
 */
if ($get->GetSharedEntityAssociationsByEntityIds(new \StructType\GetSharedEntityAssociationsByEntityIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCampaignSizesByAccountId operation/method
 */
if ($get->GetCampaignSizesByAccountId(new \StructType\GetCampaignSizesByAccountIdRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCampaignCriterionsByIds operation/method
 */
if ($get->GetCampaignCriterionsByIds(new \StructType\GetCampaignCriterionsByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBudgetsByIds operation/method
 */
if ($get->GetBudgetsByIds(new \StructType\GetBudgetsByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCampaignIdsByBudgetIds operation/method
 */
if ($get->GetCampaignIdsByBudgetIds(new \StructType\GetCampaignIdsByBudgetIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBidStrategiesByIds operation/method
 */
if ($get->GetBidStrategiesByIds(new \StructType\GetBidStrategiesByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCampaignIdsByBidStrategyIds operation/method
 */
if ($get->GetCampaignIdsByBidStrategyIds(new \StructType\GetCampaignIdsByBidStrategyIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAudiencesByIds operation/method
 */
if ($get->GetAudiencesByIds(new \StructType\GetAudiencesByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUetTagsByIds operation/method
 */
if ($get->GetUetTagsByIds(new \StructType\GetUetTagsByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetConversionGoalsByIds operation/method
 */
if ($get->GetConversionGoalsByIds(new \StructType\GetConversionGoalsByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetConversionGoalsByTagIds operation/method
 */
if ($get->GetConversionGoalsByTagIds(new \StructType\GetConversionGoalsByTagIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLabelsByIds operation/method
 */
if ($get->GetLabelsByIds(new \StructType\GetLabelsByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLabelAssociationsByEntityIds operation/method
 */
if ($get->GetLabelAssociationsByEntityIds(new \StructType\GetLabelAssociationsByEntityIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLabelAssociationsByLabelIds operation/method
 */
if ($get->GetLabelAssociationsByLabelIds(new \StructType\GetLabelAssociationsByLabelIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetExperimentsByIds operation/method
 */
if ($get->GetExperimentsByIds(new \StructType\GetExperimentsByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProfileDataFileUrl operation/method
 */
if ($get->GetProfileDataFileUrl(new \StructType\GetProfileDataFileUrlRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFileImportUploadUrl operation/method
 */
if ($get->GetFileImportUploadUrl(new \StructType\GetFileImportUploadUrlRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetImportResults operation/method
 */
if ($get->GetImportResults(new \StructType\GetImportResultsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetImportJobsByIds operation/method
 */
if ($get->GetImportJobsByIds(new \StructType\GetImportJobsByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetImportEntityIdsMapping operation/method
 */
if ($get->GetImportEntityIdsMapping(new \StructType\GetImportEntityIdsMappingRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVideosByIds operation/method
 */
if ($get->GetVideosByIds(new \StructType\GetVideosByIdsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
$delete->setSoapHeaderApplicationToken($ApplicationToken);
$delete->setSoapHeaderAuthenticationToken($AuthenticationToken);
$delete->setSoapHeaderCustomerAccountId($CustomerAccountId);
$delete->setSoapHeaderCustomerId($CustomerId);
$delete->setSoapHeaderDeveloperToken($DeveloperToken);
$delete->setSoapHeaderPassword($Password);
$delete->setSoapHeaderUserName($UserName);
/**
 * Sample call for DeleteCampaigns operation/method
 */
if ($delete->DeleteCampaigns(new \StructType\DeleteCampaignsRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteAdGroups operation/method
 */
if ($delete->DeleteAdGroups(new \StructType\DeleteAdGroupsRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteAds operation/method
 */
if ($delete->DeleteAds(new \StructType\DeleteAdsRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteKeywords operation/method
 */
if ($delete->DeleteKeywords(new \StructType\DeleteKeywordsRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteAdExtensions operation/method
 */
if ($delete->DeleteAdExtensions(new \StructType\DeleteAdExtensionsRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteAdExtensionsAssociations operation/method
 */
if ($delete->DeleteAdExtensionsAssociations(new \StructType\DeleteAdExtensionsAssociationsRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteMedia operation/method
 */
if ($delete->DeleteMedia(new \StructType\DeleteMediaRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteAdGroupCriterions operation/method
 */
if ($delete->DeleteAdGroupCriterions(new \StructType\DeleteAdGroupCriterionsRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteNegativeKeywordsFromEntities operation/method
 */
if ($delete->DeleteNegativeKeywordsFromEntities(new \StructType\DeleteNegativeKeywordsFromEntitiesRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteListItemsFromSharedList operation/method
 */
if ($delete->DeleteListItemsFromSharedList(new \StructType\DeleteListItemsFromSharedListRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteSharedEntityAssociations operation/method
 */
if ($delete->DeleteSharedEntityAssociations(new \StructType\DeleteSharedEntityAssociationsRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteSharedEntities operation/method
 */
if ($delete->DeleteSharedEntities(new \StructType\DeleteSharedEntitiesRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteCampaignCriterions operation/method
 */
if ($delete->DeleteCampaignCriterions(new \StructType\DeleteCampaignCriterionsRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteBudgets operation/method
 */
if ($delete->DeleteBudgets(new \StructType\DeleteBudgetsRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteBidStrategies operation/method
 */
if ($delete->DeleteBidStrategies(new \StructType\DeleteBidStrategiesRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteAudiences operation/method
 */
if ($delete->DeleteAudiences(new \StructType\DeleteAudiencesRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteLabels operation/method
 */
if ($delete->DeleteLabels(new \StructType\DeleteLabelsRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteLabelAssociations operation/method
 */
if ($delete->DeleteLabelAssociations(new \StructType\DeleteLabelAssociationsRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteExperiments operation/method
 */
if ($delete->DeleteExperiments(new \StructType\DeleteExperimentsRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteImportJobs operation/method
 */
if ($delete->DeleteImportJobs(new \StructType\DeleteImportJobsRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteVideos operation/method
 */
if ($delete->DeleteVideos(new \StructType\DeleteVideosRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
$update->setSoapHeaderApplicationToken($ApplicationToken);
$update->setSoapHeaderAuthenticationToken($AuthenticationToken);
$update->setSoapHeaderCustomerAccountId($CustomerAccountId);
$update->setSoapHeaderCustomerId($CustomerId);
$update->setSoapHeaderDeveloperToken($DeveloperToken);
$update->setSoapHeaderPassword($Password);
$update->setSoapHeaderUserName($UserName);
/**
 * Sample call for UpdateCampaigns operation/method
 */
if ($update->UpdateCampaigns(new \StructType\UpdateCampaignsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateAdGroups operation/method
 */
if ($update->UpdateAdGroups(new \StructType\UpdateAdGroupsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateAds operation/method
 */
if ($update->UpdateAds(new \StructType\UpdateAdsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateKeywords operation/method
 */
if ($update->UpdateKeywords(new \StructType\UpdateKeywordsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateAdExtensions operation/method
 */
if ($update->UpdateAdExtensions(new \StructType\UpdateAdExtensionsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateAdGroupCriterions operation/method
 */
if ($update->UpdateAdGroupCriterions(new \StructType\UpdateAdGroupCriterionsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSharedEntities operation/method
 */
if ($update->UpdateSharedEntities(new \StructType\UpdateSharedEntitiesRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCampaignCriterions operation/method
 */
if ($update->UpdateCampaignCriterions(new \StructType\UpdateCampaignCriterionsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateBudgets operation/method
 */
if ($update->UpdateBudgets(new \StructType\UpdateBudgetsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateBidStrategies operation/method
 */
if ($update->UpdateBidStrategies(new \StructType\UpdateBidStrategiesRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateAudiences operation/method
 */
if ($update->UpdateAudiences(new \StructType\UpdateAudiencesRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateUetTags operation/method
 */
if ($update->UpdateUetTags(new \StructType\UpdateUetTagsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateConversionGoals operation/method
 */
if ($update->UpdateConversionGoals(new \StructType\UpdateConversionGoalsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateLabels operation/method
 */
if ($update->UpdateLabels(new \StructType\UpdateLabelsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateExperiments operation/method
 */
if ($update->UpdateExperiments(new \StructType\UpdateExperimentsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateImportJobs operation/method
 */
if ($update->UpdateImportJobs(new \StructType\UpdateImportJobsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateVideos operation/method
 */
if ($update->UpdateVideos(new \StructType\UpdateVideosRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
$set->setSoapHeaderApplicationToken($ApplicationToken);
$set->setSoapHeaderAuthenticationToken($AuthenticationToken);
$set->setSoapHeaderCustomerAccountId($CustomerAccountId);
$set->setSoapHeaderCustomerId($CustomerId);
$set->setSoapHeaderDeveloperToken($DeveloperToken);
$set->setSoapHeaderPassword($Password);
$set->setSoapHeaderUserName($UserName);
/**
 * Sample call for SetNegativeSitesToCampaigns operation/method
 */
if ($set->SetNegativeSitesToCampaigns(new \StructType\SetNegativeSitesToCampaignsRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetNegativeSitesToAdGroups operation/method
 */
if ($set->SetNegativeSitesToAdGroups(new \StructType\SetNegativeSitesToAdGroupsRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetAccountProperties operation/method
 */
if ($set->SetAccountProperties(new \StructType\SetAccountPropertiesRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetAdExtensionsAssociations operation/method
 */
if ($set->SetAdExtensionsAssociations(new \StructType\SetAdExtensionsAssociationsRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetSharedEntityAssociations operation/method
 */
if ($set->SetSharedEntityAssociations(new \StructType\SetSharedEntityAssociationsRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetLabelAssociations operation/method
 */
if ($set->SetLabelAssociations(new \StructType\SetLabelAssociationsRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Appeal ServiceType
 */
$appeal = new \ServiceType\Appeal($options);
$appeal->setSoapHeaderApplicationToken($ApplicationToken);
$appeal->setSoapHeaderAuthenticationToken($AuthenticationToken);
$appeal->setSoapHeaderCustomerAccountId($CustomerAccountId);
$appeal->setSoapHeaderCustomerId($CustomerId);
$appeal->setSoapHeaderDeveloperToken($DeveloperToken);
$appeal->setSoapHeaderPassword($Password);
$appeal->setSoapHeaderUserName($UserName);
/**
 * Sample call for AppealEditorialRejections operation/method
 */
if ($appeal->AppealEditorialRejections(new \StructType\AppealEditorialRejectionsRequest()) !== false) {
    print_r($appeal->getResult());
} else {
    print_r($appeal->getLastError());
}
/**
 * Samples for Apply ServiceType
 */
$apply = new \ServiceType\Apply($options);
$apply->setSoapHeaderApplicationToken($ApplicationToken);
$apply->setSoapHeaderAuthenticationToken($AuthenticationToken);
$apply->setSoapHeaderCustomerAccountId($CustomerAccountId);
$apply->setSoapHeaderCustomerId($CustomerId);
$apply->setSoapHeaderDeveloperToken($DeveloperToken);
$apply->setSoapHeaderPassword($Password);
$apply->setSoapHeaderUserName($UserName);
/**
 * Sample call for ApplyProductPartitionActions operation/method
 */
if ($apply->ApplyProductPartitionActions(new \StructType\ApplyProductPartitionActionsRequest()) !== false) {
    print_r($apply->getResult());
} else {
    print_r($apply->getLastError());
}
/**
 * Sample call for ApplyOfflineConversions operation/method
 */
if ($apply->ApplyOfflineConversions(new \StructType\ApplyOfflineConversionsRequest()) !== false) {
    print_r($apply->getResult());
} else {
    print_r($apply->getLastError());
}
/**
 * Sample call for ApplyOfflineConversionAdjustments operation/method
 */
if ($apply->ApplyOfflineConversionAdjustments(new \StructType\ApplyOfflineConversionAdjustmentsRequest()) !== false) {
    print_r($apply->getResult());
} else {
    print_r($apply->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \ServiceType\Search($options);
$search->setSoapHeaderApplicationToken($ApplicationToken);
$search->setSoapHeaderAuthenticationToken($AuthenticationToken);
$search->setSoapHeaderCustomerAccountId($CustomerAccountId);
$search->setSoapHeaderCustomerId($CustomerId);
$search->setSoapHeaderDeveloperToken($DeveloperToken);
$search->setSoapHeaderPassword($Password);
$search->setSoapHeaderUserName($UserName);
/**
 * Sample call for SearchCompanies operation/method
 */
if ($search->SearchCompanies(new \StructType\SearchCompaniesRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
