<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebpageParameter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebpageParameter
 * @subpackage Structs
 */
class WebpageParameter extends AbstractStructBase
{
    /**
     * The Conditions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebpageCondition
     */
    public $Conditions;
    /**
     * The CriterionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CriterionName;
    /**
     * Constructor method for WebpageParameter
     * @uses WebpageParameter::setConditions()
     * @uses WebpageParameter::setCriterionName()
     * @param \ArrayType\ArrayOfWebpageCondition $conditions
     * @param string $criterionName
     */
    public function __construct(\ArrayType\ArrayOfWebpageCondition $conditions = null, $criterionName = null)
    {
        $this
            ->setConditions($conditions)
            ->setCriterionName($criterionName);
    }
    /**
     * Get Conditions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebpageCondition|null
     */
    public function getConditions()
    {
        return isset($this->Conditions) ? $this->Conditions : null;
    }
    /**
     * Set Conditions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebpageCondition $conditions
     * @return \StructType\WebpageParameter
     */
    public function setConditions(\ArrayType\ArrayOfWebpageCondition $conditions = null)
    {
        if (is_null($conditions) || (is_array($conditions) && empty($conditions))) {
            unset($this->Conditions);
        } else {
            $this->Conditions = $conditions;
        }
        return $this;
    }
    /**
     * Get CriterionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCriterionName()
    {
        return isset($this->CriterionName) ? $this->CriterionName : null;
    }
    /**
     * Set CriterionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $criterionName
     * @return \StructType\WebpageParameter
     */
    public function setCriterionName($criterionName = null)
    {
        // validation for constraint: string
        if (!is_null($criterionName) && !is_string($criterionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($criterionName, true), gettype($criterionName)), __LINE__);
        }
        if (is_null($criterionName) || (is_array($criterionName) && empty($criterionName))) {
            unset($this->CriterionName);
        } else {
            $this->CriterionName = $criterionName;
        }
        return $this;
    }
}
