<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Video StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Video
 * @subpackage Structs
 */
class Video extends AbstractStructBase
{
    /**
     * The AspectRatio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AspectRatio;
    /**
     * The CreatedDateTimeInUTC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDateTimeInUTC;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The DurationInMilliseconds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DurationInMilliseconds;
    /**
     * The FailureCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FailureCode;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Id;
    /**
     * The ModifiedDateTimeInUTC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModifiedDateTimeInUTC;
    /**
     * The SourceUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceUrl;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The ThumbnailUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThumbnailUrl;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Url;
    /**
     * Constructor method for Video
     * @uses Video::setAspectRatio()
     * @uses Video::setCreatedDateTimeInUTC()
     * @uses Video::setDescription()
     * @uses Video::setDurationInMilliseconds()
     * @uses Video::setFailureCode()
     * @uses Video::setId()
     * @uses Video::setModifiedDateTimeInUTC()
     * @uses Video::setSourceUrl()
     * @uses Video::setStatus()
     * @uses Video::setThumbnailUrl()
     * @uses Video::setUrl()
     * @param string $aspectRatio
     * @param string $createdDateTimeInUTC
     * @param string $description
     * @param int $durationInMilliseconds
     * @param string $failureCode
     * @param int $id
     * @param string $modifiedDateTimeInUTC
     * @param string $sourceUrl
     * @param string $status
     * @param string $thumbnailUrl
     * @param string $url
     */
    public function __construct($aspectRatio = null, $createdDateTimeInUTC = null, $description = null, $durationInMilliseconds = null, $failureCode = null, $id = null, $modifiedDateTimeInUTC = null, $sourceUrl = null, $status = null, $thumbnailUrl = null, $url = null)
    {
        $this
            ->setAspectRatio($aspectRatio)
            ->setCreatedDateTimeInUTC($createdDateTimeInUTC)
            ->setDescription($description)
            ->setDurationInMilliseconds($durationInMilliseconds)
            ->setFailureCode($failureCode)
            ->setId($id)
            ->setModifiedDateTimeInUTC($modifiedDateTimeInUTC)
            ->setSourceUrl($sourceUrl)
            ->setStatus($status)
            ->setThumbnailUrl($thumbnailUrl)
            ->setUrl($url);
    }
    /**
     * Get AspectRatio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAspectRatio()
    {
        return isset($this->AspectRatio) ? $this->AspectRatio : null;
    }
    /**
     * Set AspectRatio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aspectRatio
     * @return \StructType\Video
     */
    public function setAspectRatio($aspectRatio = null)
    {
        // validation for constraint: string
        if (!is_null($aspectRatio) && !is_string($aspectRatio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aspectRatio, true), gettype($aspectRatio)), __LINE__);
        }
        if (is_null($aspectRatio) || (is_array($aspectRatio) && empty($aspectRatio))) {
            unset($this->AspectRatio);
        } else {
            $this->AspectRatio = $aspectRatio;
        }
        return $this;
    }
    /**
     * Get CreatedDateTimeInUTC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDateTimeInUTC()
    {
        return isset($this->CreatedDateTimeInUTC) ? $this->CreatedDateTimeInUTC : null;
    }
    /**
     * Set CreatedDateTimeInUTC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDateTimeInUTC
     * @return \StructType\Video
     */
    public function setCreatedDateTimeInUTC($createdDateTimeInUTC = null)
    {
        // validation for constraint: string
        if (!is_null($createdDateTimeInUTC) && !is_string($createdDateTimeInUTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDateTimeInUTC, true), gettype($createdDateTimeInUTC)), __LINE__);
        }
        if (is_null($createdDateTimeInUTC) || (is_array($createdDateTimeInUTC) && empty($createdDateTimeInUTC))) {
            unset($this->CreatedDateTimeInUTC);
        } else {
            $this->CreatedDateTimeInUTC = $createdDateTimeInUTC;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\Video
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DurationInMilliseconds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDurationInMilliseconds()
    {
        return isset($this->DurationInMilliseconds) ? $this->DurationInMilliseconds : null;
    }
    /**
     * Set DurationInMilliseconds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $durationInMilliseconds
     * @return \StructType\Video
     */
    public function setDurationInMilliseconds($durationInMilliseconds = null)
    {
        // validation for constraint: int
        if (!is_null($durationInMilliseconds) && !(is_int($durationInMilliseconds) || ctype_digit($durationInMilliseconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($durationInMilliseconds, true), gettype($durationInMilliseconds)), __LINE__);
        }
        if (is_null($durationInMilliseconds) || (is_array($durationInMilliseconds) && empty($durationInMilliseconds))) {
            unset($this->DurationInMilliseconds);
        } else {
            $this->DurationInMilliseconds = $durationInMilliseconds;
        }
        return $this;
    }
    /**
     * Get FailureCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFailureCode()
    {
        return isset($this->FailureCode) ? $this->FailureCode : null;
    }
    /**
     * Set FailureCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $failureCode
     * @return \StructType\Video
     */
    public function setFailureCode($failureCode = null)
    {
        // validation for constraint: string
        if (!is_null($failureCode) && !is_string($failureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failureCode, true), gettype($failureCode)), __LINE__);
        }
        if (is_null($failureCode) || (is_array($failureCode) && empty($failureCode))) {
            unset($this->FailureCode);
        } else {
            $this->FailureCode = $failureCode;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\Video
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get ModifiedDateTimeInUTC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModifiedDateTimeInUTC()
    {
        return isset($this->ModifiedDateTimeInUTC) ? $this->ModifiedDateTimeInUTC : null;
    }
    /**
     * Set ModifiedDateTimeInUTC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modifiedDateTimeInUTC
     * @return \StructType\Video
     */
    public function setModifiedDateTimeInUTC($modifiedDateTimeInUTC = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDateTimeInUTC) && !is_string($modifiedDateTimeInUTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifiedDateTimeInUTC, true), gettype($modifiedDateTimeInUTC)), __LINE__);
        }
        if (is_null($modifiedDateTimeInUTC) || (is_array($modifiedDateTimeInUTC) && empty($modifiedDateTimeInUTC))) {
            unset($this->ModifiedDateTimeInUTC);
        } else {
            $this->ModifiedDateTimeInUTC = $modifiedDateTimeInUTC;
        }
        return $this;
    }
    /**
     * Get SourceUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceUrl()
    {
        return isset($this->SourceUrl) ? $this->SourceUrl : null;
    }
    /**
     * Set SourceUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceUrl
     * @return \StructType\Video
     */
    public function setSourceUrl($sourceUrl = null)
    {
        // validation for constraint: string
        if (!is_null($sourceUrl) && !is_string($sourceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceUrl, true), gettype($sourceUrl)), __LINE__);
        }
        if (is_null($sourceUrl) || (is_array($sourceUrl) && empty($sourceUrl))) {
            unset($this->SourceUrl);
        } else {
            $this->SourceUrl = $sourceUrl;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \StructType\Video
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get ThumbnailUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThumbnailUrl()
    {
        return isset($this->ThumbnailUrl) ? $this->ThumbnailUrl : null;
    }
    /**
     * Set ThumbnailUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $thumbnailUrl
     * @return \StructType\Video
     */
    public function setThumbnailUrl($thumbnailUrl = null)
    {
        // validation for constraint: string
        if (!is_null($thumbnailUrl) && !is_string($thumbnailUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thumbnailUrl, true), gettype($thumbnailUrl)), __LINE__);
        }
        if (is_null($thumbnailUrl) || (is_array($thumbnailUrl) && empty($thumbnailUrl))) {
            unset($this->ThumbnailUrl);
        } else {
            $this->ThumbnailUrl = $thumbnailUrl;
        }
        return $this;
    }
    /**
     * Get Url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl()
    {
        return isset($this->Url) ? $this->Url : null;
    }
    /**
     * Set Url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url
     * @return \StructType\Video
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        if (is_null($url) || (is_array($url) && empty($url))) {
            unset($this->Url);
        } else {
            $this->Url = $url;
        }
        return $this;
    }
}
