<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UrlGoal StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UrlGoal
 * @subpackage Structs
 */
class UrlGoal extends ConversionGoal
{
    /**
     * The UrlExpression
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UrlExpression;
    /**
     * The UrlOperator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UrlOperator;
    /**
     * Constructor method for UrlGoal
     * @uses UrlGoal::setUrlExpression()
     * @uses UrlGoal::setUrlOperator()
     * @param string $urlExpression
     * @param string $urlOperator
     */
    public function __construct($urlExpression = null, $urlOperator = null)
    {
        $this
            ->setUrlExpression($urlExpression)
            ->setUrlOperator($urlOperator);
    }
    /**
     * Get UrlExpression value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrlExpression()
    {
        return isset($this->UrlExpression) ? $this->UrlExpression : null;
    }
    /**
     * Set UrlExpression value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $urlExpression
     * @return \StructType\UrlGoal
     */
    public function setUrlExpression($urlExpression = null)
    {
        // validation for constraint: string
        if (!is_null($urlExpression) && !is_string($urlExpression)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlExpression, true), gettype($urlExpression)), __LINE__);
        }
        if (is_null($urlExpression) || (is_array($urlExpression) && empty($urlExpression))) {
            unset($this->UrlExpression);
        } else {
            $this->UrlExpression = $urlExpression;
        }
        return $this;
    }
    /**
     * Get UrlOperator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrlOperator()
    {
        return isset($this->UrlOperator) ? $this->UrlOperator : null;
    }
    /**
     * Set UrlOperator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ExpressionOperator::valueIsValid()
     * @uses \EnumType\ExpressionOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $urlOperator
     * @return \StructType\UrlGoal
     */
    public function setUrlOperator($urlOperator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ExpressionOperator::valueIsValid($urlOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ExpressionOperator', is_array($urlOperator) ? implode(', ', $urlOperator) : var_export($urlOperator, true), implode(', ', \EnumType\ExpressionOperator::getValidValues())), __LINE__);
        }
        if (is_null($urlOperator) || (is_array($urlOperator) && empty($urlOperator))) {
            unset($this->UrlOperator);
        } else {
            $this->UrlOperator = $urlOperator;
        }
        return $this;
    }
}
