<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImportJobsResponse StructType
 * @subpackage Structs
 */
class UpdateImportJobsResponse extends AbstractStructBase
{
    /**
     * The ImportJobIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $ImportJobIds;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for UpdateImportJobsResponse
     * @uses UpdateImportJobsResponse::setImportJobIds()
     * @uses UpdateImportJobsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOflong $importJobIds
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOflong $importJobIds = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setImportJobIds($importJobIds)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get ImportJobIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getImportJobIds()
    {
        return isset($this->ImportJobIds) ? $this->ImportJobIds : null;
    }
    /**
     * Set ImportJobIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $importJobIds
     * @return \StructType\UpdateImportJobsResponse
     */
    public function setImportJobIds(\ArrayType\ArrayOflong $importJobIds = null)
    {
        if (is_null($importJobIds) || (is_array($importJobIds) && empty($importJobIds))) {
            unset($this->ImportJobIds);
        } else {
            $this->ImportJobIds = $importJobIds;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\UpdateImportJobsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
