<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateAdGroupsRequest StructType
 * @subpackage Structs
 */
class UpdateAdGroupsRequest extends AbstractStructBase
{
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CampaignId;
    /**
     * The AdGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdGroup
     */
    public $AdGroups;
    /**
     * The UpdateAudienceAdsBidAdjustment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UpdateAudienceAdsBidAdjustment;
    /**
     * The ReturnInheritedBidStrategyTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReturnInheritedBidStrategyTypes;
    /**
     * Constructor method for UpdateAdGroupsRequest
     * @uses UpdateAdGroupsRequest::setCampaignId()
     * @uses UpdateAdGroupsRequest::setAdGroups()
     * @uses UpdateAdGroupsRequest::setUpdateAudienceAdsBidAdjustment()
     * @uses UpdateAdGroupsRequest::setReturnInheritedBidStrategyTypes()
     * @param int $campaignId
     * @param \ArrayType\ArrayOfAdGroup $adGroups
     * @param bool $updateAudienceAdsBidAdjustment
     * @param bool $returnInheritedBidStrategyTypes
     */
    public function __construct($campaignId = null, \ArrayType\ArrayOfAdGroup $adGroups = null, $updateAudienceAdsBidAdjustment = null, $returnInheritedBidStrategyTypes = null)
    {
        $this
            ->setCampaignId($campaignId)
            ->setAdGroups($adGroups)
            ->setUpdateAudienceAdsBidAdjustment($updateAudienceAdsBidAdjustment)
            ->setReturnInheritedBidStrategyTypes($returnInheritedBidStrategyTypes);
    }
    /**
     * Get CampaignId value
     * @return int|null
     */
    public function getCampaignId()
    {
        return $this->CampaignId;
    }
    /**
     * Set CampaignId value
     * @param int $campaignId
     * @return \StructType\UpdateAdGroupsRequest
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignId) && !(is_int($campaignId) || ctype_digit($campaignId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        $this->CampaignId = $campaignId;
        return $this;
    }
    /**
     * Get AdGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdGroup|null
     */
    public function getAdGroups()
    {
        return isset($this->AdGroups) ? $this->AdGroups : null;
    }
    /**
     * Set AdGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdGroup $adGroups
     * @return \StructType\UpdateAdGroupsRequest
     */
    public function setAdGroups(\ArrayType\ArrayOfAdGroup $adGroups = null)
    {
        if (is_null($adGroups) || (is_array($adGroups) && empty($adGroups))) {
            unset($this->AdGroups);
        } else {
            $this->AdGroups = $adGroups;
        }
        return $this;
    }
    /**
     * Get UpdateAudienceAdsBidAdjustment value
     * @return bool|null
     */
    public function getUpdateAudienceAdsBidAdjustment()
    {
        return $this->UpdateAudienceAdsBidAdjustment;
    }
    /**
     * Set UpdateAudienceAdsBidAdjustment value
     * @param bool $updateAudienceAdsBidAdjustment
     * @return \StructType\UpdateAdGroupsRequest
     */
    public function setUpdateAudienceAdsBidAdjustment($updateAudienceAdsBidAdjustment = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateAudienceAdsBidAdjustment) && !is_bool($updateAudienceAdsBidAdjustment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateAudienceAdsBidAdjustment, true), gettype($updateAudienceAdsBidAdjustment)), __LINE__);
        }
        $this->UpdateAudienceAdsBidAdjustment = $updateAudienceAdsBidAdjustment;
        return $this;
    }
    /**
     * Get ReturnInheritedBidStrategyTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReturnInheritedBidStrategyTypes()
    {
        return isset($this->ReturnInheritedBidStrategyTypes) ? $this->ReturnInheritedBidStrategyTypes : null;
    }
    /**
     * Set ReturnInheritedBidStrategyTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $returnInheritedBidStrategyTypes
     * @return \StructType\UpdateAdGroupsRequest
     */
    public function setReturnInheritedBidStrategyTypes($returnInheritedBidStrategyTypes = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnInheritedBidStrategyTypes) && !is_bool($returnInheritedBidStrategyTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnInheritedBidStrategyTypes, true), gettype($returnInheritedBidStrategyTypes)), __LINE__);
        }
        if (is_null($returnInheritedBidStrategyTypes) || (is_array($returnInheritedBidStrategyTypes) && empty($returnInheritedBidStrategyTypes))) {
            unset($this->ReturnInheritedBidStrategyTypes);
        } else {
            $this->ReturnInheritedBidStrategyTypes = $returnInheritedBidStrategyTypes;
        }
        return $this;
    }
}
