<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateAdExtensionsRequest StructType
 * @subpackage Structs
 */
class UpdateAdExtensionsRequest extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountId;
    /**
     * The AdExtensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdExtension
     */
    public $AdExtensions;
    /**
     * Constructor method for UpdateAdExtensionsRequest
     * @uses UpdateAdExtensionsRequest::setAccountId()
     * @uses UpdateAdExtensionsRequest::setAdExtensions()
     * @param int $accountId
     * @param \ArrayType\ArrayOfAdExtension $adExtensions
     */
    public function __construct($accountId = null, \ArrayType\ArrayOfAdExtension $adExtensions = null)
    {
        $this
            ->setAccountId($accountId)
            ->setAdExtensions($adExtensions);
    }
    /**
     * Get AccountId value
     * @return int|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\UpdateAdExtensionsRequest
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get AdExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdExtension|null
     */
    public function getAdExtensions()
    {
        return isset($this->AdExtensions) ? $this->AdExtensions : null;
    }
    /**
     * Set AdExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdExtension $adExtensions
     * @return \StructType\UpdateAdExtensionsRequest
     */
    public function setAdExtensions(\ArrayType\ArrayOfAdExtension $adExtensions = null)
    {
        if (is_null($adExtensions) || (is_array($adExtensions) && empty($adExtensions))) {
            unset($this->AdExtensions);
        } else {
            $this->AdExtensions = $adExtensions;
        }
        return $this;
    }
}
