<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TargetImpressionShareBiddingScheme StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TargetImpressionShareBiddingScheme
 * @subpackage Structs
 */
class TargetImpressionShareBiddingScheme extends BiddingScheme
{
    /**
     * The MaxCpc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Bid
     */
    public $MaxCpc;
    /**
     * The TargetAdPosition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetAdPosition;
    /**
     * The TargetImpressionShare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TargetImpressionShare;
    /**
     * Constructor method for TargetImpressionShareBiddingScheme
     * @uses TargetImpressionShareBiddingScheme::setMaxCpc()
     * @uses TargetImpressionShareBiddingScheme::setTargetAdPosition()
     * @uses TargetImpressionShareBiddingScheme::setTargetImpressionShare()
     * @param \StructType\Bid $maxCpc
     * @param string $targetAdPosition
     * @param float $targetImpressionShare
     */
    public function __construct(\StructType\Bid $maxCpc = null, $targetAdPosition = null, $targetImpressionShare = null)
    {
        $this
            ->setMaxCpc($maxCpc)
            ->setTargetAdPosition($targetAdPosition)
            ->setTargetImpressionShare($targetImpressionShare);
    }
    /**
     * Get MaxCpc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Bid|null
     */
    public function getMaxCpc()
    {
        return isset($this->MaxCpc) ? $this->MaxCpc : null;
    }
    /**
     * Set MaxCpc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Bid $maxCpc
     * @return \StructType\TargetImpressionShareBiddingScheme
     */
    public function setMaxCpc(\StructType\Bid $maxCpc = null)
    {
        if (is_null($maxCpc) || (is_array($maxCpc) && empty($maxCpc))) {
            unset($this->MaxCpc);
        } else {
            $this->MaxCpc = $maxCpc;
        }
        return $this;
    }
    /**
     * Get TargetAdPosition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetAdPosition()
    {
        return isset($this->TargetAdPosition) ? $this->TargetAdPosition : null;
    }
    /**
     * Set TargetAdPosition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetAdPosition
     * @return \StructType\TargetImpressionShareBiddingScheme
     */
    public function setTargetAdPosition($targetAdPosition = null)
    {
        // validation for constraint: string
        if (!is_null($targetAdPosition) && !is_string($targetAdPosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetAdPosition, true), gettype($targetAdPosition)), __LINE__);
        }
        if (is_null($targetAdPosition) || (is_array($targetAdPosition) && empty($targetAdPosition))) {
            unset($this->TargetAdPosition);
        } else {
            $this->TargetAdPosition = $targetAdPosition;
        }
        return $this;
    }
    /**
     * Get TargetImpressionShare value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTargetImpressionShare()
    {
        return isset($this->TargetImpressionShare) ? $this->TargetImpressionShare : null;
    }
    /**
     * Set TargetImpressionShare value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $targetImpressionShare
     * @return \StructType\TargetImpressionShareBiddingScheme
     */
    public function setTargetImpressionShare($targetImpressionShare = null)
    {
        // validation for constraint: float
        if (!is_null($targetImpressionShare) && !(is_float($targetImpressionShare) || is_numeric($targetImpressionShare))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($targetImpressionShare, true), gettype($targetImpressionShare)), __LINE__);
        }
        if (is_null($targetImpressionShare) || (is_array($targetImpressionShare) && empty($targetImpressionShare))) {
            unset($this->TargetImpressionShare);
        } else {
            $this->TargetImpressionShare = $targetImpressionShare;
        }
        return $this;
    }
}
