<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShoppingSetting StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ShoppingSetting
 * @subpackage Structs
 */
class ShoppingSetting extends Setting
{
    /**
     * The LocalInventoryAdsEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $LocalInventoryAdsEnabled;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The SalesCountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesCountryCode;
    /**
     * The StoreId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StoreId;
    /**
     * Constructor method for ShoppingSetting
     * @uses ShoppingSetting::setLocalInventoryAdsEnabled()
     * @uses ShoppingSetting::setPriority()
     * @uses ShoppingSetting::setSalesCountryCode()
     * @uses ShoppingSetting::setStoreId()
     * @param bool $localInventoryAdsEnabled
     * @param int $priority
     * @param string $salesCountryCode
     * @param int $storeId
     */
    public function __construct($localInventoryAdsEnabled = null, $priority = null, $salesCountryCode = null, $storeId = null)
    {
        $this
            ->setLocalInventoryAdsEnabled($localInventoryAdsEnabled)
            ->setPriority($priority)
            ->setSalesCountryCode($salesCountryCode)
            ->setStoreId($storeId);
    }
    /**
     * Get LocalInventoryAdsEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLocalInventoryAdsEnabled()
    {
        return isset($this->LocalInventoryAdsEnabled) ? $this->LocalInventoryAdsEnabled : null;
    }
    /**
     * Set LocalInventoryAdsEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $localInventoryAdsEnabled
     * @return \StructType\ShoppingSetting
     */
    public function setLocalInventoryAdsEnabled($localInventoryAdsEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($localInventoryAdsEnabled) && !is_bool($localInventoryAdsEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($localInventoryAdsEnabled, true), gettype($localInventoryAdsEnabled)), __LINE__);
        }
        if (is_null($localInventoryAdsEnabled) || (is_array($localInventoryAdsEnabled) && empty($localInventoryAdsEnabled))) {
            unset($this->LocalInventoryAdsEnabled);
        } else {
            $this->LocalInventoryAdsEnabled = $localInventoryAdsEnabled;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \StructType\ShoppingSetting
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get SalesCountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesCountryCode()
    {
        return isset($this->SalesCountryCode) ? $this->SalesCountryCode : null;
    }
    /**
     * Set SalesCountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesCountryCode
     * @return \StructType\ShoppingSetting
     */
    public function setSalesCountryCode($salesCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($salesCountryCode) && !is_string($salesCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesCountryCode, true), gettype($salesCountryCode)), __LINE__);
        }
        if (is_null($salesCountryCode) || (is_array($salesCountryCode) && empty($salesCountryCode))) {
            unset($this->SalesCountryCode);
        } else {
            $this->SalesCountryCode = $salesCountryCode;
        }
        return $this;
    }
    /**
     * Get StoreId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStoreId()
    {
        return isset($this->StoreId) ? $this->StoreId : null;
    }
    /**
     * Set StoreId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $storeId
     * @return \StructType\ShoppingSetting
     */
    public function setStoreId($storeId = null)
    {
        // validation for constraint: int
        if (!is_null($storeId) && !(is_int($storeId) || ctype_digit($storeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeId, true), gettype($storeId)), __LINE__);
        }
        if (is_null($storeId) || (is_array($storeId) && empty($storeId))) {
            unset($this->StoreId);
        } else {
            $this->StoreId = $storeId;
        }
        return $this;
    }
}
