<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SharedList StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SharedList
 * @subpackage Structs
 */
class SharedList extends SharedEntity
{
    /**
     * The ItemCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemCount;
    /**
     * Constructor method for SharedList
     * @uses SharedList::setItemCount()
     * @param int $itemCount
     */
    public function __construct($itemCount = null)
    {
        $this
            ->setItemCount($itemCount);
    }
    /**
     * Get ItemCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemCount()
    {
        return isset($this->ItemCount) ? $this->ItemCount : null;
    }
    /**
     * Set ItemCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemCount
     * @return \StructType\SharedList
     */
    public function setItemCount($itemCount = null)
    {
        // validation for constraint: int
        if (!is_null($itemCount) && !(is_int($itemCount) || ctype_digit($itemCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemCount, true), gettype($itemCount)), __LINE__);
        }
        if (is_null($itemCount) || (is_array($itemCount) && empty($itemCount))) {
            unset($this->ItemCount);
        } else {
            $this->ItemCount = $itemCount;
        }
        return $this;
    }
}
