<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SharedEntityAssociation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SharedEntityAssociation
 * @subpackage Structs
 */
class SharedEntityAssociation extends AbstractStructBase
{
    /**
     * The EntityId
     * @var int
     */
    public $EntityId;
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityType;
    /**
     * The SharedEntityCustomerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SharedEntityCustomerId;
    /**
     * The SharedEntityId
     * @var int
     */
    public $SharedEntityId;
    /**
     * The SharedEntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SharedEntityType;
    /**
     * Constructor method for SharedEntityAssociation
     * @uses SharedEntityAssociation::setEntityId()
     * @uses SharedEntityAssociation::setEntityType()
     * @uses SharedEntityAssociation::setSharedEntityCustomerId()
     * @uses SharedEntityAssociation::setSharedEntityId()
     * @uses SharedEntityAssociation::setSharedEntityType()
     * @param int $entityId
     * @param string $entityType
     * @param int $sharedEntityCustomerId
     * @param int $sharedEntityId
     * @param string $sharedEntityType
     */
    public function __construct($entityId = null, $entityType = null, $sharedEntityCustomerId = null, $sharedEntityId = null, $sharedEntityType = null)
    {
        $this
            ->setEntityId($entityId)
            ->setEntityType($entityType)
            ->setSharedEntityCustomerId($sharedEntityCustomerId)
            ->setSharedEntityId($sharedEntityId)
            ->setSharedEntityType($sharedEntityType);
    }
    /**
     * Get EntityId value
     * @return int|null
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }
    /**
     * Set EntityId value
     * @param int $entityId
     * @return \StructType\SharedEntityAssociation
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }
    /**
     * Get EntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityType()
    {
        return isset($this->EntityType) ? $this->EntityType : null;
    }
    /**
     * Set EntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityType
     * @return \StructType\SharedEntityAssociation
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: string
        if (!is_null($entityType) && !is_string($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityType, true), gettype($entityType)), __LINE__);
        }
        if (is_null($entityType) || (is_array($entityType) && empty($entityType))) {
            unset($this->EntityType);
        } else {
            $this->EntityType = $entityType;
        }
        return $this;
    }
    /**
     * Get SharedEntityCustomerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSharedEntityCustomerId()
    {
        return isset($this->SharedEntityCustomerId) ? $this->SharedEntityCustomerId : null;
    }
    /**
     * Set SharedEntityCustomerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sharedEntityCustomerId
     * @return \StructType\SharedEntityAssociation
     */
    public function setSharedEntityCustomerId($sharedEntityCustomerId = null)
    {
        // validation for constraint: int
        if (!is_null($sharedEntityCustomerId) && !(is_int($sharedEntityCustomerId) || ctype_digit($sharedEntityCustomerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sharedEntityCustomerId, true), gettype($sharedEntityCustomerId)), __LINE__);
        }
        if (is_null($sharedEntityCustomerId) || (is_array($sharedEntityCustomerId) && empty($sharedEntityCustomerId))) {
            unset($this->SharedEntityCustomerId);
        } else {
            $this->SharedEntityCustomerId = $sharedEntityCustomerId;
        }
        return $this;
    }
    /**
     * Get SharedEntityId value
     * @return int|null
     */
    public function getSharedEntityId()
    {
        return $this->SharedEntityId;
    }
    /**
     * Set SharedEntityId value
     * @param int $sharedEntityId
     * @return \StructType\SharedEntityAssociation
     */
    public function setSharedEntityId($sharedEntityId = null)
    {
        // validation for constraint: int
        if (!is_null($sharedEntityId) && !(is_int($sharedEntityId) || ctype_digit($sharedEntityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sharedEntityId, true), gettype($sharedEntityId)), __LINE__);
        }
        $this->SharedEntityId = $sharedEntityId;
        return $this;
    }
    /**
     * Get SharedEntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedEntityType()
    {
        return isset($this->SharedEntityType) ? $this->SharedEntityType : null;
    }
    /**
     * Set SharedEntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sharedEntityType
     * @return \StructType\SharedEntityAssociation
     */
    public function setSharedEntityType($sharedEntityType = null)
    {
        // validation for constraint: string
        if (!is_null($sharedEntityType) && !is_string($sharedEntityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sharedEntityType, true), gettype($sharedEntityType)), __LINE__);
        }
        if (is_null($sharedEntityType) || (is_array($sharedEntityType) && empty($sharedEntityType))) {
            unset($this->SharedEntityType);
        } else {
            $this->SharedEntityType = $sharedEntityType;
        }
        return $this;
    }
}
