<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchCompaniesRequest StructType
 * @subpackage Structs
 */
class SearchCompaniesRequest extends AbstractStructBase
{
    /**
     * The CompanyNameFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyNameFilter;
    /**
     * The LanguageLocale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LanguageLocale;
    /**
     * Constructor method for SearchCompaniesRequest
     * @uses SearchCompaniesRequest::setCompanyNameFilter()
     * @uses SearchCompaniesRequest::setLanguageLocale()
     * @param string $companyNameFilter
     * @param string $languageLocale
     */
    public function __construct($companyNameFilter = null, $languageLocale = null)
    {
        $this
            ->setCompanyNameFilter($companyNameFilter)
            ->setLanguageLocale($languageLocale);
    }
    /**
     * Get CompanyNameFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyNameFilter()
    {
        return isset($this->CompanyNameFilter) ? $this->CompanyNameFilter : null;
    }
    /**
     * Set CompanyNameFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyNameFilter
     * @return \StructType\SearchCompaniesRequest
     */
    public function setCompanyNameFilter($companyNameFilter = null)
    {
        // validation for constraint: string
        if (!is_null($companyNameFilter) && !is_string($companyNameFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyNameFilter, true), gettype($companyNameFilter)), __LINE__);
        }
        if (is_null($companyNameFilter) || (is_array($companyNameFilter) && empty($companyNameFilter))) {
            unset($this->CompanyNameFilter);
        } else {
            $this->CompanyNameFilter = $companyNameFilter;
        }
        return $this;
    }
    /**
     * Get LanguageLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguageLocale()
    {
        return isset($this->LanguageLocale) ? $this->LanguageLocale : null;
    }
    /**
     * Set LanguageLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $languageLocale
     * @return \StructType\SearchCompaniesRequest
     */
    public function setLanguageLocale($languageLocale = null)
    {
        // validation for constraint: string
        if (!is_null($languageLocale) && !is_string($languageLocale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageLocale, true), gettype($languageLocale)), __LINE__);
        }
        if (is_null($languageLocale) || (is_array($languageLocale) && empty($languageLocale))) {
            unset($this->LanguageLocale);
        } else {
            $this->LanguageLocale = $languageLocale;
        }
        return $this;
    }
}
