<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Schedule StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Schedule
 * @subpackage Structs
 */
class Schedule extends AbstractStructBase
{
    /**
     * The DayTimeRanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDayTime
     */
    public $DayTimeRanges;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Date
     */
    public $EndDate;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Date
     */
    public $StartDate;
    /**
     * The UseSearcherTimeZone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseSearcherTimeZone;
    /**
     * Constructor method for Schedule
     * @uses Schedule::setDayTimeRanges()
     * @uses Schedule::setEndDate()
     * @uses Schedule::setStartDate()
     * @uses Schedule::setUseSearcherTimeZone()
     * @param \ArrayType\ArrayOfDayTime $dayTimeRanges
     * @param \StructType\Date $endDate
     * @param \StructType\Date $startDate
     * @param bool $useSearcherTimeZone
     */
    public function __construct(\ArrayType\ArrayOfDayTime $dayTimeRanges = null, \StructType\Date $endDate = null, \StructType\Date $startDate = null, $useSearcherTimeZone = null)
    {
        $this
            ->setDayTimeRanges($dayTimeRanges)
            ->setEndDate($endDate)
            ->setStartDate($startDate)
            ->setUseSearcherTimeZone($useSearcherTimeZone);
    }
    /**
     * Get DayTimeRanges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDayTime|null
     */
    public function getDayTimeRanges()
    {
        return isset($this->DayTimeRanges) ? $this->DayTimeRanges : null;
    }
    /**
     * Set DayTimeRanges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDayTime $dayTimeRanges
     * @return \StructType\Schedule
     */
    public function setDayTimeRanges(\ArrayType\ArrayOfDayTime $dayTimeRanges = null)
    {
        if (is_null($dayTimeRanges) || (is_array($dayTimeRanges) && empty($dayTimeRanges))) {
            unset($this->DayTimeRanges);
        } else {
            $this->DayTimeRanges = $dayTimeRanges;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Date|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Date $endDate
     * @return \StructType\Schedule
     */
    public function setEndDate(\StructType\Date $endDate = null)
    {
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Date|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Date $startDate
     * @return \StructType\Schedule
     */
    public function setStartDate(\StructType\Date $startDate = null)
    {
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get UseSearcherTimeZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseSearcherTimeZone()
    {
        return isset($this->UseSearcherTimeZone) ? $this->UseSearcherTimeZone : null;
    }
    /**
     * Set UseSearcherTimeZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useSearcherTimeZone
     * @return \StructType\Schedule
     */
    public function setUseSearcherTimeZone($useSearcherTimeZone = null)
    {
        // validation for constraint: boolean
        if (!is_null($useSearcherTimeZone) && !is_bool($useSearcherTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useSearcherTimeZone, true), gettype($useSearcherTimeZone)), __LINE__);
        }
        if (is_null($useSearcherTimeZone) || (is_array($useSearcherTimeZone) && empty($useSearcherTimeZone))) {
            unset($this->UseSearcherTimeZone);
        } else {
            $this->UseSearcherTimeZone = $useSearcherTimeZone;
        }
        return $this;
    }
}
