<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponsiveAd StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResponsiveAd
 * @subpackage Structs
 */
class ResponsiveAd extends Ad
{
    /**
     * The BusinessName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessName;
    /**
     * The CallToAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CallToAction;
    /**
     * The CallToActionLanguage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CallToActionLanguage;
    /**
     * The Descriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAssetLink
     */
    public $Descriptions;
    /**
     * The Headline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Headline;
    /**
     * The Headlines
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAssetLink
     */
    public $Headlines;
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAssetLink
     */
    public $Images;
    /**
     * The ImpressionTrackingUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $ImpressionTrackingUrls;
    /**
     * The LongHeadline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AssetLink
     */
    public $LongHeadline;
    /**
     * The LongHeadlineString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LongHeadlineString;
    /**
     * The LongHeadlines
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAssetLink
     */
    public $LongHeadlines;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Text;
    /**
     * The Videos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAssetLink
     */
    public $Videos;
    /**
     * Constructor method for ResponsiveAd
     * @uses ResponsiveAd::setBusinessName()
     * @uses ResponsiveAd::setCallToAction()
     * @uses ResponsiveAd::setCallToActionLanguage()
     * @uses ResponsiveAd::setDescriptions()
     * @uses ResponsiveAd::setHeadline()
     * @uses ResponsiveAd::setHeadlines()
     * @uses ResponsiveAd::setImages()
     * @uses ResponsiveAd::setImpressionTrackingUrls()
     * @uses ResponsiveAd::setLongHeadline()
     * @uses ResponsiveAd::setLongHeadlineString()
     * @uses ResponsiveAd::setLongHeadlines()
     * @uses ResponsiveAd::setText()
     * @uses ResponsiveAd::setVideos()
     * @param string $businessName
     * @param string $callToAction
     * @param string $callToActionLanguage
     * @param \ArrayType\ArrayOfAssetLink $descriptions
     * @param string $headline
     * @param \ArrayType\ArrayOfAssetLink $headlines
     * @param \ArrayType\ArrayOfAssetLink $images
     * @param \ArrayType\ArrayOfstring $impressionTrackingUrls
     * @param \StructType\AssetLink $longHeadline
     * @param string $longHeadlineString
     * @param \ArrayType\ArrayOfAssetLink $longHeadlines
     * @param string $text
     * @param \ArrayType\ArrayOfAssetLink $videos
     */
    public function __construct($businessName = null, $callToAction = null, $callToActionLanguage = null, \ArrayType\ArrayOfAssetLink $descriptions = null, $headline = null, \ArrayType\ArrayOfAssetLink $headlines = null, \ArrayType\ArrayOfAssetLink $images = null, \ArrayType\ArrayOfstring $impressionTrackingUrls = null, \StructType\AssetLink $longHeadline = null, $longHeadlineString = null, \ArrayType\ArrayOfAssetLink $longHeadlines = null, $text = null, \ArrayType\ArrayOfAssetLink $videos = null)
    {
        $this
            ->setBusinessName($businessName)
            ->setCallToAction($callToAction)
            ->setCallToActionLanguage($callToActionLanguage)
            ->setDescriptions($descriptions)
            ->setHeadline($headline)
            ->setHeadlines($headlines)
            ->setImages($images)
            ->setImpressionTrackingUrls($impressionTrackingUrls)
            ->setLongHeadline($longHeadline)
            ->setLongHeadlineString($longHeadlineString)
            ->setLongHeadlines($longHeadlines)
            ->setText($text)
            ->setVideos($videos);
    }
    /**
     * Get BusinessName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessName()
    {
        return isset($this->BusinessName) ? $this->BusinessName : null;
    }
    /**
     * Set BusinessName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessName
     * @return \StructType\ResponsiveAd
     */
    public function setBusinessName($businessName = null)
    {
        // validation for constraint: string
        if (!is_null($businessName) && !is_string($businessName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessName, true), gettype($businessName)), __LINE__);
        }
        if (is_null($businessName) || (is_array($businessName) && empty($businessName))) {
            unset($this->BusinessName);
        } else {
            $this->BusinessName = $businessName;
        }
        return $this;
    }
    /**
     * Get CallToAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallToAction()
    {
        return isset($this->CallToAction) ? $this->CallToAction : null;
    }
    /**
     * Set CallToAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CallToAction::valueIsValid()
     * @uses \EnumType\CallToAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callToAction
     * @return \StructType\ResponsiveAd
     */
    public function setCallToAction($callToAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CallToAction::valueIsValid($callToAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CallToAction', is_array($callToAction) ? implode(', ', $callToAction) : var_export($callToAction, true), implode(', ', \EnumType\CallToAction::getValidValues())), __LINE__);
        }
        if (is_null($callToAction) || (is_array($callToAction) && empty($callToAction))) {
            unset($this->CallToAction);
        } else {
            $this->CallToAction = $callToAction;
        }
        return $this;
    }
    /**
     * Get CallToActionLanguage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallToActionLanguage()
    {
        return isset($this->CallToActionLanguage) ? $this->CallToActionLanguage : null;
    }
    /**
     * Set CallToActionLanguage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\LanguageName::valueIsValid()
     * @uses \EnumType\LanguageName::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callToActionLanguage
     * @return \StructType\ResponsiveAd
     */
    public function setCallToActionLanguage($callToActionLanguage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LanguageName::valueIsValid($callToActionLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LanguageName', is_array($callToActionLanguage) ? implode(', ', $callToActionLanguage) : var_export($callToActionLanguage, true), implode(', ', \EnumType\LanguageName::getValidValues())), __LINE__);
        }
        if (is_null($callToActionLanguage) || (is_array($callToActionLanguage) && empty($callToActionLanguage))) {
            unset($this->CallToActionLanguage);
        } else {
            $this->CallToActionLanguage = $callToActionLanguage;
        }
        return $this;
    }
    /**
     * Get Descriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAssetLink|null
     */
    public function getDescriptions()
    {
        return isset($this->Descriptions) ? $this->Descriptions : null;
    }
    /**
     * Set Descriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAssetLink $descriptions
     * @return \StructType\ResponsiveAd
     */
    public function setDescriptions(\ArrayType\ArrayOfAssetLink $descriptions = null)
    {
        if (is_null($descriptions) || (is_array($descriptions) && empty($descriptions))) {
            unset($this->Descriptions);
        } else {
            $this->Descriptions = $descriptions;
        }
        return $this;
    }
    /**
     * Get Headline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHeadline()
    {
        return isset($this->Headline) ? $this->Headline : null;
    }
    /**
     * Set Headline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $headline
     * @return \StructType\ResponsiveAd
     */
    public function setHeadline($headline = null)
    {
        // validation for constraint: string
        if (!is_null($headline) && !is_string($headline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($headline, true), gettype($headline)), __LINE__);
        }
        if (is_null($headline) || (is_array($headline) && empty($headline))) {
            unset($this->Headline);
        } else {
            $this->Headline = $headline;
        }
        return $this;
    }
    /**
     * Get Headlines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAssetLink|null
     */
    public function getHeadlines()
    {
        return isset($this->Headlines) ? $this->Headlines : null;
    }
    /**
     * Set Headlines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAssetLink $headlines
     * @return \StructType\ResponsiveAd
     */
    public function setHeadlines(\ArrayType\ArrayOfAssetLink $headlines = null)
    {
        if (is_null($headlines) || (is_array($headlines) && empty($headlines))) {
            unset($this->Headlines);
        } else {
            $this->Headlines = $headlines;
        }
        return $this;
    }
    /**
     * Get Images value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAssetLink|null
     */
    public function getImages()
    {
        return isset($this->Images) ? $this->Images : null;
    }
    /**
     * Set Images value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAssetLink $images
     * @return \StructType\ResponsiveAd
     */
    public function setImages(\ArrayType\ArrayOfAssetLink $images = null)
    {
        if (is_null($images) || (is_array($images) && empty($images))) {
            unset($this->Images);
        } else {
            $this->Images = $images;
        }
        return $this;
    }
    /**
     * Get ImpressionTrackingUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getImpressionTrackingUrls()
    {
        return isset($this->ImpressionTrackingUrls) ? $this->ImpressionTrackingUrls : null;
    }
    /**
     * Set ImpressionTrackingUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $impressionTrackingUrls
     * @return \StructType\ResponsiveAd
     */
    public function setImpressionTrackingUrls(\ArrayType\ArrayOfstring $impressionTrackingUrls = null)
    {
        if (is_null($impressionTrackingUrls) || (is_array($impressionTrackingUrls) && empty($impressionTrackingUrls))) {
            unset($this->ImpressionTrackingUrls);
        } else {
            $this->ImpressionTrackingUrls = $impressionTrackingUrls;
        }
        return $this;
    }
    /**
     * Get LongHeadline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AssetLink|null
     */
    public function getLongHeadline()
    {
        return isset($this->LongHeadline) ? $this->LongHeadline : null;
    }
    /**
     * Set LongHeadline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AssetLink $longHeadline
     * @return \StructType\ResponsiveAd
     */
    public function setLongHeadline(\StructType\AssetLink $longHeadline = null)
    {
        if (is_null($longHeadline) || (is_array($longHeadline) && empty($longHeadline))) {
            unset($this->LongHeadline);
        } else {
            $this->LongHeadline = $longHeadline;
        }
        return $this;
    }
    /**
     * Get LongHeadlineString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLongHeadlineString()
    {
        return isset($this->LongHeadlineString) ? $this->LongHeadlineString : null;
    }
    /**
     * Set LongHeadlineString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $longHeadlineString
     * @return \StructType\ResponsiveAd
     */
    public function setLongHeadlineString($longHeadlineString = null)
    {
        // validation for constraint: string
        if (!is_null($longHeadlineString) && !is_string($longHeadlineString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longHeadlineString, true), gettype($longHeadlineString)), __LINE__);
        }
        if (is_null($longHeadlineString) || (is_array($longHeadlineString) && empty($longHeadlineString))) {
            unset($this->LongHeadlineString);
        } else {
            $this->LongHeadlineString = $longHeadlineString;
        }
        return $this;
    }
    /**
     * Get LongHeadlines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAssetLink|null
     */
    public function getLongHeadlines()
    {
        return isset($this->LongHeadlines) ? $this->LongHeadlines : null;
    }
    /**
     * Set LongHeadlines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAssetLink $longHeadlines
     * @return \StructType\ResponsiveAd
     */
    public function setLongHeadlines(\ArrayType\ArrayOfAssetLink $longHeadlines = null)
    {
        if (is_null($longHeadlines) || (is_array($longHeadlines) && empty($longHeadlines))) {
            unset($this->LongHeadlines);
        } else {
            $this->LongHeadlines = $longHeadlines;
        }
        return $this;
    }
    /**
     * Get Text value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getText()
    {
        return isset($this->Text) ? $this->Text : null;
    }
    /**
     * Set Text value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $text
     * @return \StructType\ResponsiveAd
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        if (is_null($text) || (is_array($text) && empty($text))) {
            unset($this->Text);
        } else {
            $this->Text = $text;
        }
        return $this;
    }
    /**
     * Get Videos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAssetLink|null
     */
    public function getVideos()
    {
        return isset($this->Videos) ? $this->Videos : null;
    }
    /**
     * Set Videos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAssetLink $videos
     * @return \StructType\ResponsiveAd
     */
    public function setVideos(\ArrayType\ArrayOfAssetLink $videos = null)
    {
        if (is_null($videos) || (is_array($videos) && empty($videos))) {
            unset($this->Videos);
        } else {
            $this->Videos = $videos;
        }
        return $this;
    }
}
