<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemarketingList StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RemarketingList
 * @subpackage Structs
 */
class RemarketingList extends Audience
{
    /**
     * The Rule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RemarketingRule
     */
    public $Rule;
    /**
     * The TagId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TagId;
    /**
     * Constructor method for RemarketingList
     * @uses RemarketingList::setRule()
     * @uses RemarketingList::setTagId()
     * @param \StructType\RemarketingRule $rule
     * @param int $tagId
     */
    public function __construct(\StructType\RemarketingRule $rule = null, $tagId = null)
    {
        $this
            ->setRule($rule)
            ->setTagId($tagId);
    }
    /**
     * Get Rule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RemarketingRule|null
     */
    public function getRule()
    {
        return isset($this->Rule) ? $this->Rule : null;
    }
    /**
     * Set Rule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RemarketingRule $rule
     * @return \StructType\RemarketingList
     */
    public function setRule(\StructType\RemarketingRule $rule = null)
    {
        if (is_null($rule) || (is_array($rule) && empty($rule))) {
            unset($this->Rule);
        } else {
            $this->Rule = $rule;
        }
        return $this;
    }
    /**
     * Get TagId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTagId()
    {
        return isset($this->TagId) ? $this->TagId : null;
    }
    /**
     * Set TagId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $tagId
     * @return \StructType\RemarketingList
     */
    public function setTagId($tagId = null)
    {
        // validation for constraint: int
        if (!is_null($tagId) && !(is_int($tagId) || ctype_digit($tagId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tagId, true), gettype($tagId)), __LINE__);
        }
        if (is_null($tagId) || (is_array($tagId) && empty($tagId))) {
            unset($this->TagId);
        } else {
            $this->TagId = $tagId;
        }
        return $this;
    }
}
