<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RadiusCriterion StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RadiusCriterion
 * @subpackage Structs
 */
class RadiusCriterion extends Criterion
{
    /**
     * The LatitudeDegrees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LatitudeDegrees;
    /**
     * The LongitudeDegrees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LongitudeDegrees;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Radius
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Radius;
    /**
     * The RadiusUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RadiusUnit;
    /**
     * Constructor method for RadiusCriterion
     * @uses RadiusCriterion::setLatitudeDegrees()
     * @uses RadiusCriterion::setLongitudeDegrees()
     * @uses RadiusCriterion::setName()
     * @uses RadiusCriterion::setRadius()
     * @uses RadiusCriterion::setRadiusUnit()
     * @param float $latitudeDegrees
     * @param float $longitudeDegrees
     * @param string $name
     * @param int $radius
     * @param string $radiusUnit
     */
    public function __construct($latitudeDegrees = null, $longitudeDegrees = null, $name = null, $radius = null, $radiusUnit = null)
    {
        $this
            ->setLatitudeDegrees($latitudeDegrees)
            ->setLongitudeDegrees($longitudeDegrees)
            ->setName($name)
            ->setRadius($radius)
            ->setRadiusUnit($radiusUnit);
    }
    /**
     * Get LatitudeDegrees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLatitudeDegrees()
    {
        return isset($this->LatitudeDegrees) ? $this->LatitudeDegrees : null;
    }
    /**
     * Set LatitudeDegrees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $latitudeDegrees
     * @return \StructType\RadiusCriterion
     */
    public function setLatitudeDegrees($latitudeDegrees = null)
    {
        // validation for constraint: float
        if (!is_null($latitudeDegrees) && !(is_float($latitudeDegrees) || is_numeric($latitudeDegrees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitudeDegrees, true), gettype($latitudeDegrees)), __LINE__);
        }
        if (is_null($latitudeDegrees) || (is_array($latitudeDegrees) && empty($latitudeDegrees))) {
            unset($this->LatitudeDegrees);
        } else {
            $this->LatitudeDegrees = $latitudeDegrees;
        }
        return $this;
    }
    /**
     * Get LongitudeDegrees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLongitudeDegrees()
    {
        return isset($this->LongitudeDegrees) ? $this->LongitudeDegrees : null;
    }
    /**
     * Set LongitudeDegrees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $longitudeDegrees
     * @return \StructType\RadiusCriterion
     */
    public function setLongitudeDegrees($longitudeDegrees = null)
    {
        // validation for constraint: float
        if (!is_null($longitudeDegrees) && !(is_float($longitudeDegrees) || is_numeric($longitudeDegrees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitudeDegrees, true), gettype($longitudeDegrees)), __LINE__);
        }
        if (is_null($longitudeDegrees) || (is_array($longitudeDegrees) && empty($longitudeDegrees))) {
            unset($this->LongitudeDegrees);
        } else {
            $this->LongitudeDegrees = $longitudeDegrees;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\RadiusCriterion
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Radius value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRadius()
    {
        return isset($this->Radius) ? $this->Radius : null;
    }
    /**
     * Set Radius value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $radius
     * @return \StructType\RadiusCriterion
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: int
        if (!is_null($radius) && !(is_int($radius) || ctype_digit($radius))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($radius, true), gettype($radius)), __LINE__);
        }
        if (is_null($radius) || (is_array($radius) && empty($radius))) {
            unset($this->Radius);
        } else {
            $this->Radius = $radius;
        }
        return $this;
    }
    /**
     * Get RadiusUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRadiusUnit()
    {
        return isset($this->RadiusUnit) ? $this->RadiusUnit : null;
    }
    /**
     * Set RadiusUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DistanceUnit::valueIsValid()
     * @uses \EnumType\DistanceUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $radiusUnit
     * @return \StructType\RadiusCriterion
     */
    public function setRadiusUnit($radiusUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DistanceUnit::valueIsValid($radiusUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DistanceUnit', is_array($radiusUnit) ? implode(', ', $radiusUnit) : var_export($radiusUnit, true), implode(', ', \EnumType\DistanceUnit::getValidValues())), __LINE__);
        }
        if (is_null($radiusUnit) || (is_array($radiusUnit) && empty($radiusUnit))) {
            unset($this->RadiusUnit);
        } else {
            $this->RadiusUnit = $radiusUnit;
        }
        return $this;
    }
}
