<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileCriterion StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProfileCriterion
 * @subpackage Structs
 */
class ProfileCriterion extends Criterion
{
    /**
     * The ProfileId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProfileId;
    /**
     * The ProfileType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $ProfileType;
    /**
     * Constructor method for ProfileCriterion
     * @uses ProfileCriterion::setProfileId()
     * @uses ProfileCriterion::setProfileType()
     * @param int $profileId
     * @param string[] $profileType
     */
    public function __construct($profileId = null, array $profileType = array())
    {
        $this
            ->setProfileId($profileId)
            ->setProfileType($profileType);
    }
    /**
     * Get ProfileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->ProfileId;
    }
    /**
     * Set ProfileId value
     * @param int $profileId
     * @return \StructType\ProfileCriterion
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !(is_int($profileId) || ctype_digit($profileId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileId, true), gettype($profileId)), __LINE__);
        }
        $this->ProfileId = $profileId;
        return $this;
    }
    /**
     * Get ProfileType value
     * @return string[]|null
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * This method is responsible for validating the values passed to the setProfileType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfileType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProfileTypeForArrayConstraintsFromSetProfileType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $profileCriterionProfileTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\ProfileType::valueIsValid($profileCriterionProfileTypeItem)) {
                $invalidValues[] = is_object($profileCriterionProfileTypeItem) ? get_class($profileCriterionProfileTypeItem) : sprintf('%s(%s)', gettype($profileCriterionProfileTypeItem), var_export($profileCriterionProfileTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProfileType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\ProfileType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProfileType value
     * @uses \EnumType\ProfileType::valueIsValid()
     * @uses \EnumType\ProfileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $profileType
     * @return \StructType\ProfileCriterion
     */
    public function setProfileType(array $profileType = array())
    {
        // validation for constraint: list
        if ('' !== ($profileTypeArrayErrorMessage = self::validateProfileTypeForArrayConstraintsFromSetProfileType($profileType))) {
            throw new \InvalidArgumentException($profileTypeArrayErrorMessage, __LINE__);
        }
        $this->ProfileType = is_array($profileType) ? implode(' ', $profileType) : null;
        return $this;
    }
}
