<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductCondition StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProductCondition
 * @subpackage Structs
 */
class ProductCondition extends AbstractStructBase
{
    /**
     * The Attribute
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Attribute;
    /**
     * The Operand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operand;
    /**
     * Constructor method for ProductCondition
     * @uses ProductCondition::setAttribute()
     * @uses ProductCondition::setOperand()
     * @param string $attribute
     * @param string $operand
     */
    public function __construct($attribute = null, $operand = null)
    {
        $this
            ->setAttribute($attribute)
            ->setOperand($operand);
    }
    /**
     * Get Attribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttribute()
    {
        return isset($this->Attribute) ? $this->Attribute : null;
    }
    /**
     * Set Attribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attribute
     * @return \StructType\ProductCondition
     */
    public function setAttribute($attribute = null)
    {
        // validation for constraint: string
        if (!is_null($attribute) && !is_string($attribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attribute, true), gettype($attribute)), __LINE__);
        }
        if (is_null($attribute) || (is_array($attribute) && empty($attribute))) {
            unset($this->Attribute);
        } else {
            $this->Attribute = $attribute;
        }
        return $this;
    }
    /**
     * Get Operand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperand()
    {
        return isset($this->Operand) ? $this->Operand : null;
    }
    /**
     * Set Operand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operand
     * @return \StructType\ProductCondition
     */
    public function setOperand($operand = null)
    {
        // validation for constraint: string
        if (!is_null($operand) && !is_string($operand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operand, true), gettype($operand)), __LINE__);
        }
        if (is_null($operand) || (is_array($operand) && empty($operand))) {
            unset($this->Operand);
        } else {
            $this->Operand = $operand;
        }
        return $this;
    }
}
