<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductAd StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProductAd
 * @subpackage Structs
 */
class ProductAd extends Ad
{
    /**
     * The PromotionalText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PromotionalText;
    /**
     * Constructor method for ProductAd
     * @uses ProductAd::setPromotionalText()
     * @param string $promotionalText
     */
    public function __construct($promotionalText = null)
    {
        $this
            ->setPromotionalText($promotionalText);
    }
    /**
     * Get PromotionalText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromotionalText()
    {
        return isset($this->PromotionalText) ? $this->PromotionalText : null;
    }
    /**
     * Set PromotionalText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promotionalText
     * @return \StructType\ProductAd
     */
    public function setPromotionalText($promotionalText = null)
    {
        // validation for constraint: string
        if (!is_null($promotionalText) && !is_string($promotionalText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionalText, true), gettype($promotionalText)), __LINE__);
        }
        if (is_null($promotionalText) || (is_array($promotionalText) && empty($promotionalText))) {
            unset($this->PromotionalText);
        } else {
            $this->PromotionalText = $promotionalText;
        }
        return $this;
    }
}
