<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceTableRow StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PriceTableRow
 * @subpackage Structs
 */
class PriceTableRow extends AbstractStructBase
{
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The FinalMobileUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $FinalMobileUrls;
    /**
     * The FinalUrls
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $FinalUrls;
    /**
     * The Header
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Header;
    /**
     * The Price
     * @var float
     */
    public $Price;
    /**
     * The PriceQualifier
     * @var string
     */
    public $PriceQualifier;
    /**
     * The PriceUnit
     * @var string
     */
    public $PriceUnit;
    /**
     * The TermsAndConditions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TermsAndConditions;
    /**
     * The TermsAndConditionsUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TermsAndConditionsUrl;
    /**
     * Constructor method for PriceTableRow
     * @uses PriceTableRow::setCurrencyCode()
     * @uses PriceTableRow::setDescription()
     * @uses PriceTableRow::setFinalMobileUrls()
     * @uses PriceTableRow::setFinalUrls()
     * @uses PriceTableRow::setHeader()
     * @uses PriceTableRow::setPrice()
     * @uses PriceTableRow::setPriceQualifier()
     * @uses PriceTableRow::setPriceUnit()
     * @uses PriceTableRow::setTermsAndConditions()
     * @uses PriceTableRow::setTermsAndConditionsUrl()
     * @param string $currencyCode
     * @param string $description
     * @param \ArrayType\ArrayOfstring $finalMobileUrls
     * @param \ArrayType\ArrayOfstring $finalUrls
     * @param string $header
     * @param float $price
     * @param string $priceQualifier
     * @param string $priceUnit
     * @param string $termsAndConditions
     * @param string $termsAndConditionsUrl
     */
    public function __construct($currencyCode = null, $description = null, \ArrayType\ArrayOfstring $finalMobileUrls = null, \ArrayType\ArrayOfstring $finalUrls = null, $header = null, $price = null, $priceQualifier = null, $priceUnit = null, $termsAndConditions = null, $termsAndConditionsUrl = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->setDescription($description)
            ->setFinalMobileUrls($finalMobileUrls)
            ->setFinalUrls($finalUrls)
            ->setHeader($header)
            ->setPrice($price)
            ->setPriceQualifier($priceQualifier)
            ->setPriceUnit($priceUnit)
            ->setTermsAndConditions($termsAndConditions)
            ->setTermsAndConditionsUrl($termsAndConditionsUrl);
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\PriceTableRow
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\PriceTableRow
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get FinalMobileUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getFinalMobileUrls()
    {
        return isset($this->FinalMobileUrls) ? $this->FinalMobileUrls : null;
    }
    /**
     * Set FinalMobileUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $finalMobileUrls
     * @return \StructType\PriceTableRow
     */
    public function setFinalMobileUrls(\ArrayType\ArrayOfstring $finalMobileUrls = null)
    {
        if (is_null($finalMobileUrls) || (is_array($finalMobileUrls) && empty($finalMobileUrls))) {
            unset($this->FinalMobileUrls);
        } else {
            $this->FinalMobileUrls = $finalMobileUrls;
        }
        return $this;
    }
    /**
     * Get FinalUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getFinalUrls()
    {
        return isset($this->FinalUrls) ? $this->FinalUrls : null;
    }
    /**
     * Set FinalUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $finalUrls
     * @return \StructType\PriceTableRow
     */
    public function setFinalUrls(\ArrayType\ArrayOfstring $finalUrls = null)
    {
        if (is_null($finalUrls) || (is_array($finalUrls) && empty($finalUrls))) {
            unset($this->FinalUrls);
        } else {
            $this->FinalUrls = $finalUrls;
        }
        return $this;
    }
    /**
     * Get Header value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHeader()
    {
        return isset($this->Header) ? $this->Header : null;
    }
    /**
     * Set Header value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $header
     * @return \StructType\PriceTableRow
     */
    public function setHeader($header = null)
    {
        // validation for constraint: string
        if (!is_null($header) && !is_string($header)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($header, true), gettype($header)), __LINE__);
        }
        if (is_null($header) || (is_array($header) && empty($header))) {
            unset($this->Header);
        } else {
            $this->Header = $header;
        }
        return $this;
    }
    /**
     * Get Price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\PriceTableRow
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get PriceQualifier value
     * @return string|null
     */
    public function getPriceQualifier()
    {
        return $this->PriceQualifier;
    }
    /**
     * Set PriceQualifier value
     * @uses \EnumType\PriceQualifier::valueIsValid()
     * @uses \EnumType\PriceQualifier::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceQualifier
     * @return \StructType\PriceTableRow
     */
    public function setPriceQualifier($priceQualifier = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PriceQualifier::valueIsValid($priceQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PriceQualifier', is_array($priceQualifier) ? implode(', ', $priceQualifier) : var_export($priceQualifier, true), implode(', ', \EnumType\PriceQualifier::getValidValues())), __LINE__);
        }
        $this->PriceQualifier = $priceQualifier;
        return $this;
    }
    /**
     * Get PriceUnit value
     * @return string|null
     */
    public function getPriceUnit()
    {
        return $this->PriceUnit;
    }
    /**
     * Set PriceUnit value
     * @uses \EnumType\PriceUnit::valueIsValid()
     * @uses \EnumType\PriceUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceUnit
     * @return \StructType\PriceTableRow
     */
    public function setPriceUnit($priceUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PriceUnit::valueIsValid($priceUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PriceUnit', is_array($priceUnit) ? implode(', ', $priceUnit) : var_export($priceUnit, true), implode(', ', \EnumType\PriceUnit::getValidValues())), __LINE__);
        }
        $this->PriceUnit = $priceUnit;
        return $this;
    }
    /**
     * Get TermsAndConditions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTermsAndConditions()
    {
        return isset($this->TermsAndConditions) ? $this->TermsAndConditions : null;
    }
    /**
     * Set TermsAndConditions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $termsAndConditions
     * @return \StructType\PriceTableRow
     */
    public function setTermsAndConditions($termsAndConditions = null)
    {
        // validation for constraint: string
        if (!is_null($termsAndConditions) && !is_string($termsAndConditions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termsAndConditions, true), gettype($termsAndConditions)), __LINE__);
        }
        if (is_null($termsAndConditions) || (is_array($termsAndConditions) && empty($termsAndConditions))) {
            unset($this->TermsAndConditions);
        } else {
            $this->TermsAndConditions = $termsAndConditions;
        }
        return $this;
    }
    /**
     * Get TermsAndConditionsUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTermsAndConditionsUrl()
    {
        return isset($this->TermsAndConditionsUrl) ? $this->TermsAndConditionsUrl : null;
    }
    /**
     * Set TermsAndConditionsUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $termsAndConditionsUrl
     * @return \StructType\PriceTableRow
     */
    public function setTermsAndConditionsUrl($termsAndConditionsUrl = null)
    {
        // validation for constraint: string
        if (!is_null($termsAndConditionsUrl) && !is_string($termsAndConditionsUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termsAndConditionsUrl, true), gettype($termsAndConditionsUrl)), __LINE__);
        }
        if (is_null($termsAndConditionsUrl) || (is_array($termsAndConditionsUrl) && empty($termsAndConditionsUrl))) {
            unset($this->TermsAndConditionsUrl);
        } else {
            $this->TermsAndConditionsUrl = $termsAndConditionsUrl;
        }
        return $this;
    }
}
