<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Paging StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Paging
 * @subpackage Structs
 */
class Paging extends AbstractStructBase
{
    /**
     * The Index
     * @var int
     */
    public $Index;
    /**
     * The Size
     * @var int
     */
    public $Size;
    /**
     * Constructor method for Paging
     * @uses Paging::setIndex()
     * @uses Paging::setSize()
     * @param int $index
     * @param int $size
     */
    public function __construct($index = null, $size = null)
    {
        $this
            ->setIndex($index)
            ->setSize($size);
    }
    /**
     * Get Index value
     * @return int|null
     */
    public function getIndex()
    {
        return $this->Index;
    }
    /**
     * Set Index value
     * @param int $index
     * @return \StructType\Paging
     */
    public function setIndex($index = null)
    {
        // validation for constraint: int
        if (!is_null($index) && !(is_int($index) || ctype_digit($index))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($index, true), gettype($index)), __LINE__);
        }
        $this->Index = $index;
        return $this;
    }
    /**
     * Get Size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param int $size
     * @return \StructType\Paging
     */
    public function setSize($size = null)
    {
        // validation for constraint: int
        if (!is_null($size) && !(is_int($size) || ctype_digit($size))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->Size = $size;
        return $this;
    }
}
