<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MigrationStatusInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MigrationStatusInfo
 * @subpackage Structs
 */
class MigrationStatusInfo extends AbstractStructBase
{
    /**
     * The MigrationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MigrationType;
    /**
     * The StartTimeInUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartTimeInUtc;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for MigrationStatusInfo
     * @uses MigrationStatusInfo::setMigrationType()
     * @uses MigrationStatusInfo::setStartTimeInUtc()
     * @uses MigrationStatusInfo::setStatus()
     * @param string $migrationType
     * @param string $startTimeInUtc
     * @param string $status
     */
    public function __construct($migrationType = null, $startTimeInUtc = null, $status = null)
    {
        $this
            ->setMigrationType($migrationType)
            ->setStartTimeInUtc($startTimeInUtc)
            ->setStatus($status);
    }
    /**
     * Get MigrationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMigrationType()
    {
        return isset($this->MigrationType) ? $this->MigrationType : null;
    }
    /**
     * Set MigrationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $migrationType
     * @return \StructType\MigrationStatusInfo
     */
    public function setMigrationType($migrationType = null)
    {
        // validation for constraint: string
        if (!is_null($migrationType) && !is_string($migrationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($migrationType, true), gettype($migrationType)), __LINE__);
        }
        if (is_null($migrationType) || (is_array($migrationType) && empty($migrationType))) {
            unset($this->MigrationType);
        } else {
            $this->MigrationType = $migrationType;
        }
        return $this;
    }
    /**
     * Get StartTimeInUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartTimeInUtc()
    {
        return isset($this->StartTimeInUtc) ? $this->StartTimeInUtc : null;
    }
    /**
     * Set StartTimeInUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startTimeInUtc
     * @return \StructType\MigrationStatusInfo
     */
    public function setStartTimeInUtc($startTimeInUtc = null)
    {
        // validation for constraint: string
        if (!is_null($startTimeInUtc) && !is_string($startTimeInUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTimeInUtc, true), gettype($startTimeInUtc)), __LINE__);
        }
        if (is_null($startTimeInUtc) || (is_array($startTimeInUtc) && empty($startTimeInUtc))) {
            unset($this->StartTimeInUtc);
        } else {
            $this->StartTimeInUtc = $startTimeInUtc;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\MigrationStatus::valueIsValid()
     * @uses \EnumType\MigrationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\MigrationStatusInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MigrationStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MigrationStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\MigrationStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
