<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MediaMetaData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MediaMetaData
 * @subpackage Structs
 */
class MediaMetaData extends AbstractStructBase
{
    /**
     * The Id
     * @var int
     */
    public $Id;
    /**
     * The MediaType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MediaType;
    /**
     * The Representations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMediaRepresentation
     */
    public $Representations;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for MediaMetaData
     * @uses MediaMetaData::setId()
     * @uses MediaMetaData::setMediaType()
     * @uses MediaMetaData::setRepresentations()
     * @uses MediaMetaData::setType()
     * @param int $id
     * @param string $mediaType
     * @param \ArrayType\ArrayOfMediaRepresentation $representations
     * @param string $type
     */
    public function __construct($id = null, $mediaType = null, \ArrayType\ArrayOfMediaRepresentation $representations = null, $type = null)
    {
        $this
            ->setId($id)
            ->setMediaType($mediaType)
            ->setRepresentations($representations)
            ->setType($type);
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\MediaMetaData
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get MediaType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMediaType()
    {
        return isset($this->MediaType) ? $this->MediaType : null;
    }
    /**
     * Set MediaType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mediaType
     * @return \StructType\MediaMetaData
     */
    public function setMediaType($mediaType = null)
    {
        // validation for constraint: string
        if (!is_null($mediaType) && !is_string($mediaType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mediaType, true), gettype($mediaType)), __LINE__);
        }
        if (is_null($mediaType) || (is_array($mediaType) && empty($mediaType))) {
            unset($this->MediaType);
        } else {
            $this->MediaType = $mediaType;
        }
        return $this;
    }
    /**
     * Get Representations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMediaRepresentation|null
     */
    public function getRepresentations()
    {
        return isset($this->Representations) ? $this->Representations : null;
    }
    /**
     * Set Representations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMediaRepresentation $representations
     * @return \StructType\MediaMetaData
     */
    public function setRepresentations(\ArrayType\ArrayOfMediaRepresentation $representations = null)
    {
        if (is_null($representations) || (is_array($representations) && empty($representations))) {
            unset($this->Representations);
        } else {
            $this->Representations = $representations;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \StructType\MediaMetaData
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
