<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationAdExtension StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LocationAdExtension
 * @subpackage Structs
 */
class LocationAdExtension extends AdExtension
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyName;
    /**
     * The GeoCodeStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeoCodeStatus;
    /**
     * The GeoPoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GeoPoint
     */
    public $GeoPoint;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhoneNumber;
    /**
     * Constructor method for LocationAdExtension
     * @uses LocationAdExtension::setAddress()
     * @uses LocationAdExtension::setCompanyName()
     * @uses LocationAdExtension::setGeoCodeStatus()
     * @uses LocationAdExtension::setGeoPoint()
     * @uses LocationAdExtension::setPhoneNumber()
     * @param \StructType\Address $address
     * @param string $companyName
     * @param string $geoCodeStatus
     * @param \StructType\GeoPoint $geoPoint
     * @param string $phoneNumber
     */
    public function __construct(\StructType\Address $address = null, $companyName = null, $geoCodeStatus = null, \StructType\GeoPoint $geoPoint = null, $phoneNumber = null)
    {
        $this
            ->setAddress($address)
            ->setCompanyName($companyName)
            ->setGeoCodeStatus($geoCodeStatus)
            ->setGeoPoint($geoPoint)
            ->setPhoneNumber($phoneNumber);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Address $address
     * @return \StructType\LocationAdExtension
     */
    public function setAddress(\StructType\Address $address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get CompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyName()
    {
        return isset($this->CompanyName) ? $this->CompanyName : null;
    }
    /**
     * Set CompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyName
     * @return \StructType\LocationAdExtension
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        if (is_null($companyName) || (is_array($companyName) && empty($companyName))) {
            unset($this->CompanyName);
        } else {
            $this->CompanyName = $companyName;
        }
        return $this;
    }
    /**
     * Get GeoCodeStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeoCodeStatus()
    {
        return isset($this->GeoCodeStatus) ? $this->GeoCodeStatus : null;
    }
    /**
     * Set GeoCodeStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\BusinessGeoCodeStatus::valueIsValid()
     * @uses \EnumType\BusinessGeoCodeStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoCodeStatus
     * @return \StructType\LocationAdExtension
     */
    public function setGeoCodeStatus($geoCodeStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusinessGeoCodeStatus::valueIsValid($geoCodeStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BusinessGeoCodeStatus', is_array($geoCodeStatus) ? implode(', ', $geoCodeStatus) : var_export($geoCodeStatus, true), implode(', ', \EnumType\BusinessGeoCodeStatus::getValidValues())), __LINE__);
        }
        if (is_null($geoCodeStatus) || (is_array($geoCodeStatus) && empty($geoCodeStatus))) {
            unset($this->GeoCodeStatus);
        } else {
            $this->GeoCodeStatus = $geoCodeStatus;
        }
        return $this;
    }
    /**
     * Get GeoPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GeoPoint|null
     */
    public function getGeoPoint()
    {
        return isset($this->GeoPoint) ? $this->GeoPoint : null;
    }
    /**
     * Set GeoPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GeoPoint $geoPoint
     * @return \StructType\LocationAdExtension
     */
    public function setGeoPoint(\StructType\GeoPoint $geoPoint = null)
    {
        if (is_null($geoPoint) || (is_array($geoPoint) && empty($geoPoint))) {
            unset($this->GeoPoint);
        } else {
            $this->GeoPoint = $geoPoint;
        }
        return $this;
    }
    /**
     * Get PhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return isset($this->PhoneNumber) ? $this->PhoneNumber : null;
    }
    /**
     * Set PhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phoneNumber
     * @return \StructType\LocationAdExtension
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        if (is_null($phoneNumber) || (is_array($phoneNumber) && empty($phoneNumber))) {
            unset($this->PhoneNumber);
        } else {
            $this->PhoneNumber = $phoneNumber;
        }
        return $this;
    }
}
