<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelAssociation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LabelAssociation
 * @subpackage Structs
 */
class LabelAssociation extends AbstractStructBase
{
    /**
     * The EntityId
     * @var int
     */
    public $EntityId;
    /**
     * The LabelId
     * @var int
     */
    public $LabelId;
    /**
     * Constructor method for LabelAssociation
     * @uses LabelAssociation::setEntityId()
     * @uses LabelAssociation::setLabelId()
     * @param int $entityId
     * @param int $labelId
     */
    public function __construct($entityId = null, $labelId = null)
    {
        $this
            ->setEntityId($entityId)
            ->setLabelId($labelId);
    }
    /**
     * Get EntityId value
     * @return int|null
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }
    /**
     * Set EntityId value
     * @param int $entityId
     * @return \StructType\LabelAssociation
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }
    /**
     * Get LabelId value
     * @return int|null
     */
    public function getLabelId()
    {
        return $this->LabelId;
    }
    /**
     * Set LabelId value
     * @param int $labelId
     * @return \StructType\LabelAssociation
     */
    public function setLabelId($labelId = null)
    {
        // validation for constraint: int
        if (!is_null($labelId) && !(is_int($labelId) || ctype_digit($labelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($labelId, true), gettype($labelId)), __LINE__);
        }
        $this->LabelId = $labelId;
        return $this;
    }
}
