<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeyValuePairOflonglong StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:KeyValuePairOflonglong
 * @subpackage Structs
 */
class KeyValuePairOflonglong extends AbstractStructBase
{
    /**
     * The key
     * @var int
     */
    public $key;
    /**
     * The value
     * @var int
     */
    public $value;
    /**
     * Constructor method for KeyValuePairOflonglong
     * @uses KeyValuePairOflonglong::setKey()
     * @uses KeyValuePairOflonglong::setValue()
     * @param int $key
     * @param int $value
     */
    public function __construct($key = null, $value = null)
    {
        $this
            ->setKey($key)
            ->setValue($value);
    }
    /**
     * Get key value
     * @return int|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param int $key
     * @return \StructType\KeyValuePairOflonglong
     */
    public function setKey($key = null)
    {
        // validation for constraint: int
        if (!is_null($key) && !(is_int($key) || ctype_digit($key))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get value value
     * @return int|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param int $value
     * @return \StructType\KeyValuePairOflonglong
     */
    public function setValue($value = null)
    {
        // validation for constraint: int
        if (!is_null($value) && !(is_int($value) || ctype_digit($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
}
