<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ImportResult
 * @subpackage Structs
 */
class ImportResult extends AbstractStructBase
{
    /**
     * The EntityStatistics
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfImportEntityStatistics
     */
    public $EntityStatistics;
    /**
     * The ErrorLogUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorLogUrl;
    /**
     * The ForwardCompatibilityMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKeyValuePairOfstringstring
     */
    public $ForwardCompatibilityMap;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Id;
    /**
     * The ImportJob
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ImportJob
     */
    public $ImportJob;
    /**
     * The StartTimeInUTC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartTimeInUTC;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * Constructor method for ImportResult
     * @uses ImportResult::setEntityStatistics()
     * @uses ImportResult::setErrorLogUrl()
     * @uses ImportResult::setForwardCompatibilityMap()
     * @uses ImportResult::setId()
     * @uses ImportResult::setImportJob()
     * @uses ImportResult::setStartTimeInUTC()
     * @uses ImportResult::setStatus()
     * @param \ArrayType\ArrayOfImportEntityStatistics $entityStatistics
     * @param string $errorLogUrl
     * @param \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap
     * @param string $id
     * @param \StructType\ImportJob $importJob
     * @param string $startTimeInUTC
     * @param string $status
     */
    public function __construct(\ArrayType\ArrayOfImportEntityStatistics $entityStatistics = null, $errorLogUrl = null, \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap = null, $id = null, \StructType\ImportJob $importJob = null, $startTimeInUTC = null, $status = null)
    {
        $this
            ->setEntityStatistics($entityStatistics)
            ->setErrorLogUrl($errorLogUrl)
            ->setForwardCompatibilityMap($forwardCompatibilityMap)
            ->setId($id)
            ->setImportJob($importJob)
            ->setStartTimeInUTC($startTimeInUTC)
            ->setStatus($status);
    }
    /**
     * Get EntityStatistics value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfImportEntityStatistics|null
     */
    public function getEntityStatistics()
    {
        return isset($this->EntityStatistics) ? $this->EntityStatistics : null;
    }
    /**
     * Set EntityStatistics value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfImportEntityStatistics $entityStatistics
     * @return \StructType\ImportResult
     */
    public function setEntityStatistics(\ArrayType\ArrayOfImportEntityStatistics $entityStatistics = null)
    {
        if (is_null($entityStatistics) || (is_array($entityStatistics) && empty($entityStatistics))) {
            unset($this->EntityStatistics);
        } else {
            $this->EntityStatistics = $entityStatistics;
        }
        return $this;
    }
    /**
     * Get ErrorLogUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorLogUrl()
    {
        return isset($this->ErrorLogUrl) ? $this->ErrorLogUrl : null;
    }
    /**
     * Set ErrorLogUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorLogUrl
     * @return \StructType\ImportResult
     */
    public function setErrorLogUrl($errorLogUrl = null)
    {
        // validation for constraint: string
        if (!is_null($errorLogUrl) && !is_string($errorLogUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorLogUrl, true), gettype($errorLogUrl)), __LINE__);
        }
        if (is_null($errorLogUrl) || (is_array($errorLogUrl) && empty($errorLogUrl))) {
            unset($this->ErrorLogUrl);
        } else {
            $this->ErrorLogUrl = $errorLogUrl;
        }
        return $this;
    }
    /**
     * Get ForwardCompatibilityMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKeyValuePairOfstringstring|null
     */
    public function getForwardCompatibilityMap()
    {
        return isset($this->ForwardCompatibilityMap) ? $this->ForwardCompatibilityMap : null;
    }
    /**
     * Set ForwardCompatibilityMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap
     * @return \StructType\ImportResult
     */
    public function setForwardCompatibilityMap(\ArrayType\ArrayOfKeyValuePairOfstringstring $forwardCompatibilityMap = null)
    {
        if (is_null($forwardCompatibilityMap) || (is_array($forwardCompatibilityMap) && empty($forwardCompatibilityMap))) {
            unset($this->ForwardCompatibilityMap);
        } else {
            $this->ForwardCompatibilityMap = $forwardCompatibilityMap;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \StructType\ImportResult
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get ImportJob value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ImportJob|null
     */
    public function getImportJob()
    {
        return isset($this->ImportJob) ? $this->ImportJob : null;
    }
    /**
     * Set ImportJob value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ImportJob $importJob
     * @return \StructType\ImportResult
     */
    public function setImportJob(\StructType\ImportJob $importJob = null)
    {
        if (is_null($importJob) || (is_array($importJob) && empty($importJob))) {
            unset($this->ImportJob);
        } else {
            $this->ImportJob = $importJob;
        }
        return $this;
    }
    /**
     * Get StartTimeInUTC value
     * @return string|null
     */
    public function getStartTimeInUTC()
    {
        return $this->StartTimeInUTC;
    }
    /**
     * Set StartTimeInUTC value
     * @param string $startTimeInUTC
     * @return \StructType\ImportResult
     */
    public function setStartTimeInUTC($startTimeInUTC = null)
    {
        // validation for constraint: string
        if (!is_null($startTimeInUTC) && !is_string($startTimeInUTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTimeInUTC, true), gettype($startTimeInUTC)), __LINE__);
        }
        $this->StartTimeInUTC = $startTimeInUTC;
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \StructType\ImportResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
