<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageAsset StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ImageAsset
 * @subpackage Structs
 */
class ImageAsset extends Asset
{
    /**
     * The CropHeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CropHeight;
    /**
     * The CropWidth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CropWidth;
    /**
     * The CropX
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CropX;
    /**
     * The CropY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CropY;
    /**
     * The SubType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubType;
    /**
     * Constructor method for ImageAsset
     * @uses ImageAsset::setCropHeight()
     * @uses ImageAsset::setCropWidth()
     * @uses ImageAsset::setCropX()
     * @uses ImageAsset::setCropY()
     * @uses ImageAsset::setSubType()
     * @param int $cropHeight
     * @param int $cropWidth
     * @param int $cropX
     * @param int $cropY
     * @param string $subType
     */
    public function __construct($cropHeight = null, $cropWidth = null, $cropX = null, $cropY = null, $subType = null)
    {
        $this
            ->setCropHeight($cropHeight)
            ->setCropWidth($cropWidth)
            ->setCropX($cropX)
            ->setCropY($cropY)
            ->setSubType($subType);
    }
    /**
     * Get CropHeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCropHeight()
    {
        return isset($this->CropHeight) ? $this->CropHeight : null;
    }
    /**
     * Set CropHeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cropHeight
     * @return \StructType\ImageAsset
     */
    public function setCropHeight($cropHeight = null)
    {
        // validation for constraint: int
        if (!is_null($cropHeight) && !(is_int($cropHeight) || ctype_digit($cropHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cropHeight, true), gettype($cropHeight)), __LINE__);
        }
        if (is_null($cropHeight) || (is_array($cropHeight) && empty($cropHeight))) {
            unset($this->CropHeight);
        } else {
            $this->CropHeight = $cropHeight;
        }
        return $this;
    }
    /**
     * Get CropWidth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCropWidth()
    {
        return isset($this->CropWidth) ? $this->CropWidth : null;
    }
    /**
     * Set CropWidth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cropWidth
     * @return \StructType\ImageAsset
     */
    public function setCropWidth($cropWidth = null)
    {
        // validation for constraint: int
        if (!is_null($cropWidth) && !(is_int($cropWidth) || ctype_digit($cropWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cropWidth, true), gettype($cropWidth)), __LINE__);
        }
        if (is_null($cropWidth) || (is_array($cropWidth) && empty($cropWidth))) {
            unset($this->CropWidth);
        } else {
            $this->CropWidth = $cropWidth;
        }
        return $this;
    }
    /**
     * Get CropX value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCropX()
    {
        return isset($this->CropX) ? $this->CropX : null;
    }
    /**
     * Set CropX value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cropX
     * @return \StructType\ImageAsset
     */
    public function setCropX($cropX = null)
    {
        // validation for constraint: int
        if (!is_null($cropX) && !(is_int($cropX) || ctype_digit($cropX))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cropX, true), gettype($cropX)), __LINE__);
        }
        if (is_null($cropX) || (is_array($cropX) && empty($cropX))) {
            unset($this->CropX);
        } else {
            $this->CropX = $cropX;
        }
        return $this;
    }
    /**
     * Get CropY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCropY()
    {
        return isset($this->CropY) ? $this->CropY : null;
    }
    /**
     * Set CropY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cropY
     * @return \StructType\ImageAsset
     */
    public function setCropY($cropY = null)
    {
        // validation for constraint: int
        if (!is_null($cropY) && !(is_int($cropY) || ctype_digit($cropY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cropY, true), gettype($cropY)), __LINE__);
        }
        if (is_null($cropY) || (is_array($cropY) && empty($cropY))) {
            unset($this->CropY);
        } else {
            $this->CropY = $cropY;
        }
        return $this;
    }
    /**
     * Get SubType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubType()
    {
        return isset($this->SubType) ? $this->SubType : null;
    }
    /**
     * Set SubType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subType
     * @return \StructType\ImageAsset
     */
    public function setSubType($subType = null)
    {
        // validation for constraint: string
        if (!is_null($subType) && !is_string($subType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subType, true), gettype($subType)), __LINE__);
        }
        if (is_null($subType) || (is_array($subType) && empty($subType))) {
            unset($this->SubType);
        } else {
            $this->SubType = $subType;
        }
        return $this;
    }
}
