<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoogleImportJob StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GoogleImportJob
 * @subpackage Structs
 */
class GoogleImportJob extends ImportJob
{
    /**
     * The CampaignAdGroupIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCampaignAdGroupIds
     */
    public $CampaignAdGroupIds;
    /**
     * The CredentialId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CredentialId;
    /**
     * The GoogleAccountId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $GoogleAccountId;
    /**
     * The GoogleUserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GoogleUserName;
    /**
     * Constructor method for GoogleImportJob
     * @uses GoogleImportJob::setCampaignAdGroupIds()
     * @uses GoogleImportJob::setCredentialId()
     * @uses GoogleImportJob::setGoogleAccountId()
     * @uses GoogleImportJob::setGoogleUserName()
     * @param \ArrayType\ArrayOfCampaignAdGroupIds $campaignAdGroupIds
     * @param string $credentialId
     * @param int $googleAccountId
     * @param string $googleUserName
     */
    public function __construct(\ArrayType\ArrayOfCampaignAdGroupIds $campaignAdGroupIds = null, $credentialId = null, $googleAccountId = null, $googleUserName = null)
    {
        $this
            ->setCampaignAdGroupIds($campaignAdGroupIds)
            ->setCredentialId($credentialId)
            ->setGoogleAccountId($googleAccountId)
            ->setGoogleUserName($googleUserName);
    }
    /**
     * Get CampaignAdGroupIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCampaignAdGroupIds|null
     */
    public function getCampaignAdGroupIds()
    {
        return isset($this->CampaignAdGroupIds) ? $this->CampaignAdGroupIds : null;
    }
    /**
     * Set CampaignAdGroupIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCampaignAdGroupIds $campaignAdGroupIds
     * @return \StructType\GoogleImportJob
     */
    public function setCampaignAdGroupIds(\ArrayType\ArrayOfCampaignAdGroupIds $campaignAdGroupIds = null)
    {
        if (is_null($campaignAdGroupIds) || (is_array($campaignAdGroupIds) && empty($campaignAdGroupIds))) {
            unset($this->CampaignAdGroupIds);
        } else {
            $this->CampaignAdGroupIds = $campaignAdGroupIds;
        }
        return $this;
    }
    /**
     * Get CredentialId value
     * @return string|null
     */
    public function getCredentialId()
    {
        return $this->CredentialId;
    }
    /**
     * Set CredentialId value
     * @param string $credentialId
     * @return \StructType\GoogleImportJob
     */
    public function setCredentialId($credentialId = null)
    {
        // validation for constraint: string
        if (!is_null($credentialId) && !is_string($credentialId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credentialId, true), gettype($credentialId)), __LINE__);
        }
        $this->CredentialId = $credentialId;
        return $this;
    }
    /**
     * Get GoogleAccountId value
     * @return int|null
     */
    public function getGoogleAccountId()
    {
        return $this->GoogleAccountId;
    }
    /**
     * Set GoogleAccountId value
     * @param int $googleAccountId
     * @return \StructType\GoogleImportJob
     */
    public function setGoogleAccountId($googleAccountId = null)
    {
        // validation for constraint: int
        if (!is_null($googleAccountId) && !(is_int($googleAccountId) || ctype_digit($googleAccountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($googleAccountId, true), gettype($googleAccountId)), __LINE__);
        }
        $this->GoogleAccountId = $googleAccountId;
        return $this;
    }
    /**
     * Get GoogleUserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGoogleUserName()
    {
        return isset($this->GoogleUserName) ? $this->GoogleUserName : null;
    }
    /**
     * Set GoogleUserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $googleUserName
     * @return \StructType\GoogleImportJob
     */
    public function setGoogleUserName($googleUserName = null)
    {
        // validation for constraint: string
        if (!is_null($googleUserName) && !is_string($googleUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($googleUserName, true), gettype($googleUserName)), __LINE__);
        }
        if (is_null($googleUserName) || (is_array($googleUserName) && empty($googleUserName))) {
            unset($this->GoogleUserName);
        } else {
            $this->GoogleUserName = $googleUserName;
        }
        return $this;
    }
}
