<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSharedEntityAssociationsBySharedEntityIdsRequest
 * StructType
 * @subpackage Structs
 */
class GetSharedEntityAssociationsBySharedEntityIdsRequest extends AbstractStructBase
{
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityType;
    /**
     * The SharedEntityIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $SharedEntityIds;
    /**
     * The SharedEntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SharedEntityType;
    /**
     * The SharedEntityScope
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SharedEntityScope;
    /**
     * Constructor method for GetSharedEntityAssociationsBySharedEntityIdsRequest
     * @uses GetSharedEntityAssociationsBySharedEntityIdsRequest::setEntityType()
     * @uses GetSharedEntityAssociationsBySharedEntityIdsRequest::setSharedEntityIds()
     * @uses GetSharedEntityAssociationsBySharedEntityIdsRequest::setSharedEntityType()
     * @uses GetSharedEntityAssociationsBySharedEntityIdsRequest::setSharedEntityScope()
     * @param string $entityType
     * @param \ArrayType\ArrayOflong $sharedEntityIds
     * @param string $sharedEntityType
     * @param string $sharedEntityScope
     */
    public function __construct($entityType = null, \ArrayType\ArrayOflong $sharedEntityIds = null, $sharedEntityType = null, $sharedEntityScope = null)
    {
        $this
            ->setEntityType($entityType)
            ->setSharedEntityIds($sharedEntityIds)
            ->setSharedEntityType($sharedEntityType)
            ->setSharedEntityScope($sharedEntityScope);
    }
    /**
     * Get EntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityType()
    {
        return isset($this->EntityType) ? $this->EntityType : null;
    }
    /**
     * Set EntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityType
     * @return \StructType\GetSharedEntityAssociationsBySharedEntityIdsRequest
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: string
        if (!is_null($entityType) && !is_string($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityType, true), gettype($entityType)), __LINE__);
        }
        if (is_null($entityType) || (is_array($entityType) && empty($entityType))) {
            unset($this->EntityType);
        } else {
            $this->EntityType = $entityType;
        }
        return $this;
    }
    /**
     * Get SharedEntityIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getSharedEntityIds()
    {
        return isset($this->SharedEntityIds) ? $this->SharedEntityIds : null;
    }
    /**
     * Set SharedEntityIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $sharedEntityIds
     * @return \StructType\GetSharedEntityAssociationsBySharedEntityIdsRequest
     */
    public function setSharedEntityIds(\ArrayType\ArrayOflong $sharedEntityIds = null)
    {
        if (is_null($sharedEntityIds) || (is_array($sharedEntityIds) && empty($sharedEntityIds))) {
            unset($this->SharedEntityIds);
        } else {
            $this->SharedEntityIds = $sharedEntityIds;
        }
        return $this;
    }
    /**
     * Get SharedEntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedEntityType()
    {
        return isset($this->SharedEntityType) ? $this->SharedEntityType : null;
    }
    /**
     * Set SharedEntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sharedEntityType
     * @return \StructType\GetSharedEntityAssociationsBySharedEntityIdsRequest
     */
    public function setSharedEntityType($sharedEntityType = null)
    {
        // validation for constraint: string
        if (!is_null($sharedEntityType) && !is_string($sharedEntityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sharedEntityType, true), gettype($sharedEntityType)), __LINE__);
        }
        if (is_null($sharedEntityType) || (is_array($sharedEntityType) && empty($sharedEntityType))) {
            unset($this->SharedEntityType);
        } else {
            $this->SharedEntityType = $sharedEntityType;
        }
        return $this;
    }
    /**
     * Get SharedEntityScope value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedEntityScope()
    {
        return isset($this->SharedEntityScope) ? $this->SharedEntityScope : null;
    }
    /**
     * Set SharedEntityScope value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\EntityScope::valueIsValid()
     * @uses \EnumType\EntityScope::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sharedEntityScope
     * @return \StructType\GetSharedEntityAssociationsBySharedEntityIdsRequest
     */
    public function setSharedEntityScope($sharedEntityScope = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityScope::valueIsValid($sharedEntityScope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityScope', is_array($sharedEntityScope) ? implode(', ', $sharedEntityScope) : var_export($sharedEntityScope, true), implode(', ', \EnumType\EntityScope::getValidValues())), __LINE__);
        }
        if (is_null($sharedEntityScope) || (is_array($sharedEntityScope) && empty($sharedEntityScope))) {
            unset($this->SharedEntityScope);
        } else {
            $this->SharedEntityScope = $sharedEntityScope;
        }
        return $this;
    }
}
