<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetNegativeSitesByAdGroupIdsResponse StructType
 * @subpackage Structs
 */
class GetNegativeSitesByAdGroupIdsResponse extends AbstractStructBase
{
    /**
     * The AdGroupNegativeSites
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdGroupNegativeSites
     */
    public $AdGroupNegativeSites;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetNegativeSitesByAdGroupIdsResponse
     * @uses GetNegativeSitesByAdGroupIdsResponse::setAdGroupNegativeSites()
     * @uses GetNegativeSitesByAdGroupIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfAdGroupNegativeSites $adGroupNegativeSites
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfAdGroupNegativeSites $adGroupNegativeSites = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setAdGroupNegativeSites($adGroupNegativeSites)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get AdGroupNegativeSites value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdGroupNegativeSites|null
     */
    public function getAdGroupNegativeSites()
    {
        return isset($this->AdGroupNegativeSites) ? $this->AdGroupNegativeSites : null;
    }
    /**
     * Set AdGroupNegativeSites value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdGroupNegativeSites $adGroupNegativeSites
     * @return \StructType\GetNegativeSitesByAdGroupIdsResponse
     */
    public function setAdGroupNegativeSites(\ArrayType\ArrayOfAdGroupNegativeSites $adGroupNegativeSites = null)
    {
        if (is_null($adGroupNegativeSites) || (is_array($adGroupNegativeSites) && empty($adGroupNegativeSites))) {
            unset($this->AdGroupNegativeSites);
        } else {
            $this->AdGroupNegativeSites = $adGroupNegativeSites;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetNegativeSitesByAdGroupIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
