<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetNegativeKeywordsByEntityIdsResponse StructType
 * @subpackage Structs
 */
class GetNegativeKeywordsByEntityIdsResponse extends AbstractStructBase
{
    /**
     * The EntityNegativeKeywords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEntityNegativeKeyword
     */
    public $EntityNegativeKeywords;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetNegativeKeywordsByEntityIdsResponse
     * @uses GetNegativeKeywordsByEntityIdsResponse::setEntityNegativeKeywords()
     * @uses GetNegativeKeywordsByEntityIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfEntityNegativeKeyword $entityNegativeKeywords
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfEntityNegativeKeyword $entityNegativeKeywords = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setEntityNegativeKeywords($entityNegativeKeywords)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get EntityNegativeKeywords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEntityNegativeKeyword|null
     */
    public function getEntityNegativeKeywords()
    {
        return isset($this->EntityNegativeKeywords) ? $this->EntityNegativeKeywords : null;
    }
    /**
     * Set EntityNegativeKeywords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEntityNegativeKeyword $entityNegativeKeywords
     * @return \StructType\GetNegativeKeywordsByEntityIdsResponse
     */
    public function setEntityNegativeKeywords(\ArrayType\ArrayOfEntityNegativeKeyword $entityNegativeKeywords = null)
    {
        if (is_null($entityNegativeKeywords) || (is_array($entityNegativeKeywords) && empty($entityNegativeKeywords))) {
            unset($this->EntityNegativeKeywords);
        } else {
            $this->EntityNegativeKeywords = $entityNegativeKeywords;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetNegativeKeywordsByEntityIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
