<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMediaAssociationsRequest StructType
 * @subpackage Structs
 */
class GetMediaAssociationsRequest extends AbstractStructBase
{
    /**
     * The MediaEnabledEntities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $MediaEnabledEntities;
    /**
     * The MediaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $MediaIds;
    /**
     * Constructor method for GetMediaAssociationsRequest
     * @uses GetMediaAssociationsRequest::setMediaEnabledEntities()
     * @uses GetMediaAssociationsRequest::setMediaIds()
     * @param string[] $mediaEnabledEntities
     * @param \ArrayType\ArrayOflong $mediaIds
     */
    public function __construct(array $mediaEnabledEntities = array(), \ArrayType\ArrayOflong $mediaIds = null)
    {
        $this
            ->setMediaEnabledEntities($mediaEnabledEntities)
            ->setMediaIds($mediaIds);
    }
    /**
     * Get MediaEnabledEntities value
     * @return string[]|null
     */
    public function getMediaEnabledEntities()
    {
        return $this->MediaEnabledEntities;
    }
    /**
     * This method is responsible for validating the values passed to the setMediaEnabledEntities method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMediaEnabledEntities method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMediaEnabledEntitiesForArrayConstraintsFromSetMediaEnabledEntities(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getMediaAssociationsRequestMediaEnabledEntitiesItem) {
            // validation for constraint: enumeration
            if (!\EnumType\MediaEnabledEntityFilter::valueIsValid($getMediaAssociationsRequestMediaEnabledEntitiesItem)) {
                $invalidValues[] = is_object($getMediaAssociationsRequestMediaEnabledEntitiesItem) ? get_class($getMediaAssociationsRequestMediaEnabledEntitiesItem) : sprintf('%s(%s)', gettype($getMediaAssociationsRequestMediaEnabledEntitiesItem), var_export($getMediaAssociationsRequestMediaEnabledEntitiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MediaEnabledEntityFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\MediaEnabledEntityFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MediaEnabledEntities value
     * @uses \EnumType\MediaEnabledEntityFilter::valueIsValid()
     * @uses \EnumType\MediaEnabledEntityFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $mediaEnabledEntities
     * @return \StructType\GetMediaAssociationsRequest
     */
    public function setMediaEnabledEntities(array $mediaEnabledEntities = array())
    {
        // validation for constraint: list
        if ('' !== ($mediaEnabledEntitiesArrayErrorMessage = self::validateMediaEnabledEntitiesForArrayConstraintsFromSetMediaEnabledEntities($mediaEnabledEntities))) {
            throw new \InvalidArgumentException($mediaEnabledEntitiesArrayErrorMessage, __LINE__);
        }
        $this->MediaEnabledEntities = is_array($mediaEnabledEntities) ? implode(' ', $mediaEnabledEntities) : null;
        return $this;
    }
    /**
     * Get MediaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getMediaIds()
    {
        return isset($this->MediaIds) ? $this->MediaIds : null;
    }
    /**
     * Set MediaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $mediaIds
     * @return \StructType\GetMediaAssociationsRequest
     */
    public function setMediaIds(\ArrayType\ArrayOflong $mediaIds = null)
    {
        if (is_null($mediaIds) || (is_array($mediaIds) && empty($mediaIds))) {
            unset($this->MediaIds);
        } else {
            $this->MediaIds = $mediaIds;
        }
        return $this;
    }
}
