<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLabelsByIdsRequest StructType
 * @subpackage Structs
 */
class GetLabelsByIdsRequest extends AbstractStructBase
{
    /**
     * The LabelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $LabelIds;
    /**
     * The PageInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Paging
     */
    public $PageInfo;
    /**
     * Constructor method for GetLabelsByIdsRequest
     * @uses GetLabelsByIdsRequest::setLabelIds()
     * @uses GetLabelsByIdsRequest::setPageInfo()
     * @param \ArrayType\ArrayOflong $labelIds
     * @param \StructType\Paging $pageInfo
     */
    public function __construct(\ArrayType\ArrayOflong $labelIds = null, \StructType\Paging $pageInfo = null)
    {
        $this
            ->setLabelIds($labelIds)
            ->setPageInfo($pageInfo);
    }
    /**
     * Get LabelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getLabelIds()
    {
        return isset($this->LabelIds) ? $this->LabelIds : null;
    }
    /**
     * Set LabelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $labelIds
     * @return \StructType\GetLabelsByIdsRequest
     */
    public function setLabelIds(\ArrayType\ArrayOflong $labelIds = null)
    {
        if (is_null($labelIds) || (is_array($labelIds) && empty($labelIds))) {
            unset($this->LabelIds);
        } else {
            $this->LabelIds = $labelIds;
        }
        return $this;
    }
    /**
     * Get PageInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Paging|null
     */
    public function getPageInfo()
    {
        return isset($this->PageInfo) ? $this->PageInfo : null;
    }
    /**
     * Set PageInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Paging $pageInfo
     * @return \StructType\GetLabelsByIdsRequest
     */
    public function setPageInfo(\StructType\Paging $pageInfo = null)
    {
        if (is_null($pageInfo) || (is_array($pageInfo) && empty($pageInfo))) {
            unset($this->PageInfo);
        } else {
            $this->PageInfo = $pageInfo;
        }
        return $this;
    }
}
