<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLabelAssociationsByLabelIdsRequest StructType
 * @subpackage Structs
 */
class GetLabelAssociationsByLabelIdsRequest extends AbstractStructBase
{
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EntityType;
    /**
     * The LabelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $LabelIds;
    /**
     * The PageInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Paging
     */
    public $PageInfo;
    /**
     * Constructor method for GetLabelAssociationsByLabelIdsRequest
     * @uses GetLabelAssociationsByLabelIdsRequest::setEntityType()
     * @uses GetLabelAssociationsByLabelIdsRequest::setLabelIds()
     * @uses GetLabelAssociationsByLabelIdsRequest::setPageInfo()
     * @param string $entityType
     * @param \ArrayType\ArrayOflong $labelIds
     * @param \StructType\Paging $pageInfo
     */
    public function __construct($entityType = null, \ArrayType\ArrayOflong $labelIds = null, \StructType\Paging $pageInfo = null)
    {
        $this
            ->setEntityType($entityType)
            ->setLabelIds($labelIds)
            ->setPageInfo($pageInfo);
    }
    /**
     * Get EntityType value
     * @return string|null
     */
    public function getEntityType()
    {
        return $this->EntityType;
    }
    /**
     * Set EntityType value
     * @uses \EnumType\EntityType::valueIsValid()
     * @uses \EnumType\EntityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $entityType
     * @return \StructType\GetLabelAssociationsByLabelIdsRequest
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityType::valueIsValid($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityType', is_array($entityType) ? implode(', ', $entityType) : var_export($entityType, true), implode(', ', \EnumType\EntityType::getValidValues())), __LINE__);
        }
        $this->EntityType = $entityType;
        return $this;
    }
    /**
     * Get LabelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getLabelIds()
    {
        return isset($this->LabelIds) ? $this->LabelIds : null;
    }
    /**
     * Set LabelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $labelIds
     * @return \StructType\GetLabelAssociationsByLabelIdsRequest
     */
    public function setLabelIds(\ArrayType\ArrayOflong $labelIds = null)
    {
        if (is_null($labelIds) || (is_array($labelIds) && empty($labelIds))) {
            unset($this->LabelIds);
        } else {
            $this->LabelIds = $labelIds;
        }
        return $this;
    }
    /**
     * Get PageInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Paging|null
     */
    public function getPageInfo()
    {
        return isset($this->PageInfo) ? $this->PageInfo : null;
    }
    /**
     * Set PageInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Paging $pageInfo
     * @return \StructType\GetLabelAssociationsByLabelIdsRequest
     */
    public function setPageInfo(\StructType\Paging $pageInfo = null)
    {
        if (is_null($pageInfo) || (is_array($pageInfo) && empty($pageInfo))) {
            unset($this->PageInfo);
        } else {
            $this->PageInfo = $pageInfo;
        }
        return $this;
    }
}
