<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetKeywordsByEditorialStatusRequest StructType
 * @subpackage Structs
 */
class GetKeywordsByEditorialStatusRequest extends AbstractStructBase
{
    /**
     * The AdGroupId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AdGroupId;
    /**
     * The EditorialStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EditorialStatus;
    /**
     * Constructor method for GetKeywordsByEditorialStatusRequest
     * @uses GetKeywordsByEditorialStatusRequest::setAdGroupId()
     * @uses GetKeywordsByEditorialStatusRequest::setEditorialStatus()
     * @param int $adGroupId
     * @param string $editorialStatus
     */
    public function __construct($adGroupId = null, $editorialStatus = null)
    {
        $this
            ->setAdGroupId($adGroupId)
            ->setEditorialStatus($editorialStatus);
    }
    /**
     * Get AdGroupId value
     * @return int|null
     */
    public function getAdGroupId()
    {
        return $this->AdGroupId;
    }
    /**
     * Set AdGroupId value
     * @param int $adGroupId
     * @return \StructType\GetKeywordsByEditorialStatusRequest
     */
    public function setAdGroupId($adGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($adGroupId) && !(is_int($adGroupId) || ctype_digit($adGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adGroupId, true), gettype($adGroupId)), __LINE__);
        }
        $this->AdGroupId = $adGroupId;
        return $this;
    }
    /**
     * Get EditorialStatus value
     * @return string|null
     */
    public function getEditorialStatus()
    {
        return $this->EditorialStatus;
    }
    /**
     * Set EditorialStatus value
     * @uses \EnumType\KeywordEditorialStatus::valueIsValid()
     * @uses \EnumType\KeywordEditorialStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $editorialStatus
     * @return \StructType\GetKeywordsByEditorialStatusRequest
     */
    public function setEditorialStatus($editorialStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KeywordEditorialStatus::valueIsValid($editorialStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KeywordEditorialStatus', is_array($editorialStatus) ? implode(', ', $editorialStatus) : var_export($editorialStatus, true), implode(', ', \EnumType\KeywordEditorialStatus::getValidValues())), __LINE__);
        }
        $this->EditorialStatus = $editorialStatus;
        return $this;
    }
}
