<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetImportResultsRequest StructType
 * @subpackage Structs
 */
class GetImportResultsRequest extends AbstractStructBase
{
    /**
     * The ImportType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportType;
    /**
     * The PageInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Paging
     */
    public $PageInfo;
    /**
     * The ImportJobIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $ImportJobIds;
    /**
     * The ReturnAdditionalFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ReturnAdditionalFields;
    /**
     * Constructor method for GetImportResultsRequest
     * @uses GetImportResultsRequest::setImportType()
     * @uses GetImportResultsRequest::setPageInfo()
     * @uses GetImportResultsRequest::setImportJobIds()
     * @uses GetImportResultsRequest::setReturnAdditionalFields()
     * @param string $importType
     * @param \StructType\Paging $pageInfo
     * @param \ArrayType\ArrayOflong $importJobIds
     * @param string[] $returnAdditionalFields
     */
    public function __construct($importType = null, \StructType\Paging $pageInfo = null, \ArrayType\ArrayOflong $importJobIds = null, array $returnAdditionalFields = array())
    {
        $this
            ->setImportType($importType)
            ->setPageInfo($pageInfo)
            ->setImportJobIds($importJobIds)
            ->setReturnAdditionalFields($returnAdditionalFields);
    }
    /**
     * Get ImportType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportType()
    {
        return isset($this->ImportType) ? $this->ImportType : null;
    }
    /**
     * Set ImportType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importType
     * @return \StructType\GetImportResultsRequest
     */
    public function setImportType($importType = null)
    {
        // validation for constraint: string
        if (!is_null($importType) && !is_string($importType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importType, true), gettype($importType)), __LINE__);
        }
        if (is_null($importType) || (is_array($importType) && empty($importType))) {
            unset($this->ImportType);
        } else {
            $this->ImportType = $importType;
        }
        return $this;
    }
    /**
     * Get PageInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Paging|null
     */
    public function getPageInfo()
    {
        return isset($this->PageInfo) ? $this->PageInfo : null;
    }
    /**
     * Set PageInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Paging $pageInfo
     * @return \StructType\GetImportResultsRequest
     */
    public function setPageInfo(\StructType\Paging $pageInfo = null)
    {
        if (is_null($pageInfo) || (is_array($pageInfo) && empty($pageInfo))) {
            unset($this->PageInfo);
        } else {
            $this->PageInfo = $pageInfo;
        }
        return $this;
    }
    /**
     * Get ImportJobIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getImportJobIds()
    {
        return isset($this->ImportJobIds) ? $this->ImportJobIds : null;
    }
    /**
     * Set ImportJobIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $importJobIds
     * @return \StructType\GetImportResultsRequest
     */
    public function setImportJobIds(\ArrayType\ArrayOflong $importJobIds = null)
    {
        if (is_null($importJobIds) || (is_array($importJobIds) && empty($importJobIds))) {
            unset($this->ImportJobIds);
        } else {
            $this->ImportJobIds = $importJobIds;
        }
        return $this;
    }
    /**
     * Get ReturnAdditionalFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getReturnAdditionalFields()
    {
        return isset($this->ReturnAdditionalFields) ? $this->ReturnAdditionalFields : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnAdditionalFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnAdditionalFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getImportResultsRequestReturnAdditionalFieldsItem) {
            // validation for constraint: enumeration
            if (!\EnumType\ImportAdditionalField::valueIsValid($getImportResultsRequestReturnAdditionalFieldsItem)) {
                $invalidValues[] = is_object($getImportResultsRequestReturnAdditionalFieldsItem) ? get_class($getImportResultsRequestReturnAdditionalFieldsItem) : sprintf('%s(%s)', gettype($getImportResultsRequestReturnAdditionalFieldsItem), var_export($getImportResultsRequestReturnAdditionalFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ImportAdditionalField', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\ImportAdditionalField::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnAdditionalFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ImportAdditionalField::valueIsValid()
     * @uses \EnumType\ImportAdditionalField::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $returnAdditionalFields
     * @return \StructType\GetImportResultsRequest
     */
    public function setReturnAdditionalFields(array $returnAdditionalFields = array())
    {
        // validation for constraint: list
        if ('' !== ($returnAdditionalFieldsArrayErrorMessage = self::validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields($returnAdditionalFields))) {
            throw new \InvalidArgumentException($returnAdditionalFieldsArrayErrorMessage, __LINE__);
        }
        if (is_null($returnAdditionalFields) || (is_array($returnAdditionalFields) && empty($returnAdditionalFields))) {
            unset($this->ReturnAdditionalFields);
        } else {
            $this->ReturnAdditionalFields = is_array($returnAdditionalFields) ? implode(' ', $returnAdditionalFields) : null;
        }
        return $this;
    }
}
