<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetImportJobsByIdsRequest StructType
 * @subpackage Structs
 */
class GetImportJobsByIdsRequest extends AbstractStructBase
{
    /**
     * The ImportJobIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $ImportJobIds;
    /**
     * The ImportType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportType;
    /**
     * The ReturnAdditionalFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ReturnAdditionalFields;
    /**
     * Constructor method for GetImportJobsByIdsRequest
     * @uses GetImportJobsByIdsRequest::setImportJobIds()
     * @uses GetImportJobsByIdsRequest::setImportType()
     * @uses GetImportJobsByIdsRequest::setReturnAdditionalFields()
     * @param \ArrayType\ArrayOflong $importJobIds
     * @param string $importType
     * @param string[] $returnAdditionalFields
     */
    public function __construct(\ArrayType\ArrayOflong $importJobIds = null, $importType = null, array $returnAdditionalFields = array())
    {
        $this
            ->setImportJobIds($importJobIds)
            ->setImportType($importType)
            ->setReturnAdditionalFields($returnAdditionalFields);
    }
    /**
     * Get ImportJobIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getImportJobIds()
    {
        return isset($this->ImportJobIds) ? $this->ImportJobIds : null;
    }
    /**
     * Set ImportJobIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $importJobIds
     * @return \StructType\GetImportJobsByIdsRequest
     */
    public function setImportJobIds(\ArrayType\ArrayOflong $importJobIds = null)
    {
        if (is_null($importJobIds) || (is_array($importJobIds) && empty($importJobIds))) {
            unset($this->ImportJobIds);
        } else {
            $this->ImportJobIds = $importJobIds;
        }
        return $this;
    }
    /**
     * Get ImportType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportType()
    {
        return isset($this->ImportType) ? $this->ImportType : null;
    }
    /**
     * Set ImportType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importType
     * @return \StructType\GetImportJobsByIdsRequest
     */
    public function setImportType($importType = null)
    {
        // validation for constraint: string
        if (!is_null($importType) && !is_string($importType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importType, true), gettype($importType)), __LINE__);
        }
        if (is_null($importType) || (is_array($importType) && empty($importType))) {
            unset($this->ImportType);
        } else {
            $this->ImportType = $importType;
        }
        return $this;
    }
    /**
     * Get ReturnAdditionalFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getReturnAdditionalFields()
    {
        return isset($this->ReturnAdditionalFields) ? $this->ReturnAdditionalFields : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnAdditionalFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnAdditionalFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getImportJobsByIdsRequestReturnAdditionalFieldsItem) {
            // validation for constraint: enumeration
            if (!\EnumType\ImportAdditionalField::valueIsValid($getImportJobsByIdsRequestReturnAdditionalFieldsItem)) {
                $invalidValues[] = is_object($getImportJobsByIdsRequestReturnAdditionalFieldsItem) ? get_class($getImportJobsByIdsRequestReturnAdditionalFieldsItem) : sprintf('%s(%s)', gettype($getImportJobsByIdsRequestReturnAdditionalFieldsItem), var_export($getImportJobsByIdsRequestReturnAdditionalFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ImportAdditionalField', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\ImportAdditionalField::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnAdditionalFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ImportAdditionalField::valueIsValid()
     * @uses \EnumType\ImportAdditionalField::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $returnAdditionalFields
     * @return \StructType\GetImportJobsByIdsRequest
     */
    public function setReturnAdditionalFields(array $returnAdditionalFields = array())
    {
        // validation for constraint: list
        if ('' !== ($returnAdditionalFieldsArrayErrorMessage = self::validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields($returnAdditionalFields))) {
            throw new \InvalidArgumentException($returnAdditionalFieldsArrayErrorMessage, __LINE__);
        }
        if (is_null($returnAdditionalFields) || (is_array($returnAdditionalFields) && empty($returnAdditionalFields))) {
            unset($this->ReturnAdditionalFields);
        } else {
            $this->ReturnAdditionalFields = is_array($returnAdditionalFields) ? implode(' ', $returnAdditionalFields) : null;
        }
        return $this;
    }
}
